<?php
include("cls5.php");
Class Cls6 extends Cls5 {

/* **************** **************** **************** ****************
                            ZION RETREATS FUNCTIONS
------- zion retreat list functions -------
01) ltzrt - list zion retreat table content
02) ltzrs - list zion retreat actions submit
03) ltzrc - list zion retreat additional css content
04) ltzrj - list zion retreat additional js content
05) ltzca - list zion retreat count array return

------- manage zion retreat main functions -------
01) mgzrt - manage zion retreat html content
02) mgzrs - manage zion retreat actions main submit
03) mgzrc - manage zion retreat additional css content
04) mgzrj - manage zion retreat additional js content

------- manage zion retreat supporting functions -------
01) mgzos - open status update submit
02) mgzas - allocate member submit
03) mgzal - allocated member list html content
04) mbamd - allocated member edit modal html content
05) mgzds - delete allocated member submit

------- preview zion retreat functions -------
01) pwzrt - preview zion retreat html content
02) pwzrc - preview zion retreat additional css content
03) pwzrj - preview zion retreat additional js content

**************** **************** **************** **************** */

// ------- zion retreat list functions -------
// ltzrt - list zion retreat table content
function ltzrt() {
GLOBAL $dbcn, $wpfx;

	// total zion retreat count initialize
	$tzct = 0;
	// opened zion retreat count initialize
	$ozct = 0;
	// incompleted zion retreat count initialize
	$izct = 0;
	// history zion retreat count initialize
	$hzct = 0;

	// select main list data from database as per the inputs
	try {

		// zion retreat selection query
		$sqla = sprintf("SELECT zrt_edt, zrt_ost FROM zrt_tbl");
		$resa = $dbcn->prepare($sqla);
		$resa->execute();

		// fetch the datas from the database into the row variable
		while($rowa = $resa->fetch()) {

			// increment total zion retreats
			$tzct++;
			// zion retreat end time to unix time
			$rteu = $rowa['zrt_edt'];

			// if opened and upcoming/running zion retreat
			if($rowa['zrt_ost'] == 333 && date('U') < $rteu) {

				// opened zion retreat count increment
				$ozct ++;

			} // active admin check close

			// if upcoming/running zion retreat
			if(date('U') < $rteu) {

				// incompleted zion retreat count increment
				$izct ++;

			} // upcoming/running zion retreat check close

			// if completed zion retreat
			if(date('U') >= $rteu) {

				// completed zion retreat count increment
				$hzct ++;

			} // completed zion retreat check close

		} // main list while loop iteration close

	} catch(Exception $e) {
	} // main list selection close

	// input hiddens for form
	$inhd = $this->inhdn();

// page wrap start tag start
$cont = <<<AAA
<div class="page-body">

AAA; //page wrap start tag close

	// opened retreat class as per list selection
	$opcn = (isset($_GET['val1']) && $_GET['val1'] == 'opened')
				?
			'btn-primary'
				:
			'btn-light';
	// incompleted retreat class as per list selection
	$iccn = (isset($_GET['val1']) && $_GET['val1'] == 'incompleted')
				?
			'btn-primary'
				:
			'btn-light';
	// completed retreat class as per list selection
	$cpcn = (isset($_GET['val1']) && $_GET['val1'] == 'completed')
				?
			'btn-primary'
				:
			'btn-light';

// links container start tag start
$cont .= <<<AAA
	<div class="text-center mb-3">
		<div class="btn-group">
			<a href="{$wpfx}zion-retreats-list/opened" class="btn $opcn light-card f-w-500 f-15">Opened</a>
			<a href="{$wpfx}zion-retreats-list/incompleted" class="btn $iccn light-card f-w-500 f-15">Incompleted</a>
			<a href="{$wpfx}zion-retreats-list/completed" class="btn $cpcn f-w-500 f-15">Completed</a>
		</div>
	</div>

AAA; // links container start tag close

// statistics container start tag start
$cont .= <<<AAA
	<div class="container default-dashboard">
		<div class="owl-carousel sale-statistic stat--slider">

AAA; // statistics container start tag close

	// opacity class management
	$opop = 'opacity-50';	$icop = '';	$cmop = 'opacity-50';

	// if opened selected, set other two opacity to 50%
	if(isset($_GET['val1']) && $_GET['val1'] == 'opened') {

		// opacity class management
		$opop = '';	$icop = 'opacity-50';	$cmop = 'opacity-50';

	// if completed selected, set other two opacity to 50%
	} else if(isset($_GET['val1']) && $_GET['val1'] == 'completed') {

		// opacity class management
		$opop = 'opacity-50';	$icop = 'opacity-50';	$cmop = '';

	} // get value check for opacity close

	// zion retreat count
	$cont .= str_replace("-icon", "-icon opacity-50", $this->stbmk('common-total.png', 'Total', 'retreats', $tzct, 'success', 'slide-right'));
	// opened zion retreat count
	$cont .= str_replace("-icon", "-icon " . $opop, $this->stbmk('common-opened.png', 'Opened', 'retreats', $ozct, 'primary', 'slide-up'));
	// incompleted zion retreat count
	$cont .= str_replace("-icon", "-icon " . $icop, $this->stbmk('common-incompleted.png', 'Incompleted', 'retreats', $izct, 'warning', 'slide-up'));
	// completed zion retreat count
	$cont .= str_replace("-icon", "-icon " . $cmop, $this->stbmk('common-history.png', 'Completed', 'retreats', $hzct, 'danger', 'slide-left'));

// statistics container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // statistics container close tag close

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-12">
				<div class="card">

AAA; // card start tag close

	// checkbox list variables initialize
	$cblt = '';
	// checkbox header variables initialize
	$cbhd = '';
	// checkbox footer variables initialize
	$cbft = '';
	// checkbox count variables initialize
	$itct = 0;

	// checkbox array
	$cbar = array(
					array('chkd'=>333, 'coln'=>1, 'valt'=>'Retreat')
					,array('chkd'=>333, 'coln'=>2, 'valt'=>'Date')
					,array('chkd'=>999, 'coln'=>3, 'valt'=>'Amount')
					,array('chkd'=>333, 'coln'=>4, 'valt'=>'Open Status')
					,array('chkd'=>999, 'coln'=>5, 'valt'=>'Status')
					,array('chkd'=>999, 'coln'=>6, 'valt'=>'Language')
					,array('chkd'=>333, 'coln'=>7, 'valt'=>'Booking Count')
					,array('chkd'=>333, 'coln'=>8, 'valt'=>'Regn Count')
					,array('chkd'=>999, 'coln'=>9, 'valt'=>'Regn Allocated Admins')
				);

	// sl no thead into variable
	$cbhd .= '<th data-ptp="0" data-psh="1">S.N</th>';
	// sl no tfoot into variable
	$cbft .= '<th>S.N</th>';

	// iterate through checkbox array
	foreach($cbar as $cbky => $cbvl) {

		// checkbox into variable
		$cblt .= sprintf('
							<li>
								<div class="checkbox checkbox-colvis checkbox-primary mb-0 mt-0 ps-3 pe-2">
									<input class="d-none toggle-vis" id="clvc%s" type="checkbox" data-column="%s" %s>
									<label class="form-check-label" for="clvc%s">%s</label>
								</div>
							</li>'
							,$itct
							,$cbvl['coln']
							,$cbvl['chkd'] == 333
								?
							'checked'
								:
							''
							,$itct
							,$cbvl['valt']
						);

		// increment count variable
		$itct++;

		// thead into variable
		$cbhd .= sprintf('
							<th data-ptp="%s" data-psh="%s">%s</th>'
							,$itct
							,$cbvl['chkd'] == 333
								?
							1
								:
							0
							,$cbvl['valt']
						);

		// tfoot into variable
		$cbft .= sprintf('
							<th>%s</th>'
							,$cbvl['valt']
						);

	} // checkbox array iteration close

	// actions thead into variable variable
	$cbhd .= '<th data-ptp="' . $itct . '" data-psh="1" class="notexport dtend text-center">Actions</th>';
	// actions tfoot into variable
	$cbft .= '<th class="text-center">Actions</th>';

// card header tag start
$cont .= <<<AAA
					<div class="card-header">
						<div class="mt-2">
							<div class="btnbk d-inline-block"></div>
							<div class="d-inline-block">
								<div class="dropdown colVs">
									<button class="btn btn-secondary btn-colvis btn-datatable-main dropdown-toggle colvis-dropdown" type="button" id="toggleCol" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
										Column Visibility
									</button>
									<ul class="dropdown-menu colvDp p-3" aria-labelledby="toggleCol">
										$cblt
									</ul>
								</div>
							</div>
						</div>
					</div>

AAA; // card header tag close

	// date for file name
	$fldt = date("d-M-Y h_iA");
	// file download name
	$fldn = 'Zion retreat list on';

// card body tag start
$cont .= <<<AAA
					<div class="card-body">
						<div class="">
							<table class="table table-bordered w-100" id="dttbl" data-tbttl="$fldn $fldt">
								<thead class="thead-light">
									<tr class="phd-mn">
										$cbhd
									</tr>
								</thead>
								<tbody>
								</tbody>
								<tfoot>
									<tr>
										$cbft
									</tr>
								</tfoot>
							</table>
						</div>
					</div>

AAA; // card body tag close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

// page wrap close tag start
$cont .= <<<AAA
</div>

AAA; // page wrap close tag close
echo $cont;

}
// ltzrs - list zion retreat actions submit
function ltzrs() {
}
// ltzrc - list zion retreat additional css content
function ltzrc() {

	// aoscs - aos animation css initialize call
	$this->aoscs();
	// owlsc - owl caraousel for statistics css initialize call
	$this->owlsc();
	// dtldc - datatable loader animation css initialize call
	$this->dtldc();
	// ohmbc - member block display on hover css initialize call
	$this->ohmbc();

}
// ltzrj - list zion retreat additional js content
function ltzrj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();
	// owlsj - owl animation for statistics js initialize call
	$this->owlsj();
	// dtldj - datatable loader animation js initialize call
	$this->dtldj();
	// ohmbj - member block display on hover js initialize call
	$this->ohmbj('zion-retreat');

// zion retreat list select from database ajax content making start, script tag close is done in dtbcl()
$cont = <<<'AAA'
			<script>
				var ccnt = dataTable.rows().count();
				var cttp = '';

AAA; // zion retreat list select close

// if v1 value is set
if(isset($_GET['val1'])) {

// zion retreat list select from database ajax content making start
$cont .= <<<AAA
				var cttp = '{$_GET['val1']}';

AAA; // zion retreat list select close

} // v1 value set check close

// zion retreat list select from database ajax content making start
$cont .= <<<'AAA'
				var fmct = new FormData();
				fmct.append('idtf', '2807');
				fmct.append('ccnt', ccnt);
				fmct.append('cttp', cttp);
				fchDt(fmct);

AAA; // zion retreats select from database ajax content making close
echo $cont;

	// dtbcl - datatable content loading js initialize call
	$this->dtbcl();

}
// ltzca - list zion retreat count array return
function ltzca() {
GLOBAL $dbcn;

	// booking count array initialize
	$rtar['bcar'] = array();
	// registration count array initialize
	$rtar['rcar'] = array();

	// page visit into log
	$this->sbmli(NULL, @$_SESSION['urid'], 'Zion retreat count array requested', 'zion-retreat', 'zion-retreat-pg');

	// select zion retreat booking count data
	try {

		// zion retreat booking count data selection query
		$sqlb = "SELECT COUNT(*) as bcnt, bku_zri FROM bkg_tbl WHERE bku_sts=:bku_sts GROUP BY bku_zri";
		$resb = $dbcn->prepare($sqlb);
		$resb->execute([
						'bku_sts'=>333
					]);

		// fetch the datas from the database into the row variable
		while($rowb = $resb->fetch()) {

			// booking count array initialize
			$rtar['bcar'][$rowb['bku_zri']] = $rowb['bcnt'];

		} // booking count select while loop close

	} catch(Exception $e) {

		// error log into file
		$this->errli(NULL, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

	} // select zion retreat booking count data close

	// select zion retreat registration count data
	try {

		// zion retreat registration count data selection query
		$sqlr = "SELECT COUNT(*) as rcnt, rgn_zri FROM rgn_tbl WHERE rgn_sts=:rgn_sts GROUP BY rgn_zri";
		$resr = $dbcn->prepare($sqlr);
		$resr->execute([
						'rgn_sts'=>333
					]);

		// fetch the datas from the database into the row variable
		while($rowr = $resr->fetch()) {

			// registration count array initialize
			$rtar['rcar'][$rowr['rgn_zri']] = $rowr['rcnt'];

		} // registration count select while loop close

	} catch(Exception $e) {

		// error log into file
		$this->errli(NULL, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

	} // select zion retreat registration count data close

	// return count array
	return $rtar;

}


// ------- manage zion retreat main functions -------
// mgzrt - manage zion retreat html content
function mgzrt() {
GLOBAL $dbcn, $wpfx;

	// check get value and hash are matching
	if(isset($_GET['val1'], $_GET['val2']) && $_GET['val2'] == md5("^#" . $_GET['val1'] . "#^")) {

		// id value into variable
		$val1 = $_GET['val1'];

		// page visit into log
		$this->sbmli($val1, @$_SESSION['urid'], 'Manage zion retreat page requested', 'zion-retreat', 'zion-retreat-pg');

		// select data as per given id from database
		try {

			// zion retreat data selection query
			$sqlz = sprintf("
								SELECT zrt_tbl.zrt_mid, zrt_tbl.zrt_sdt, zrt_tbl.zrt_edt, zrt_tbl.zrt_act, zrt_tbl.zrt_cct, zrt_tbl.zrt_tns, zrt_tbl.zrt_ost, zrt_tbl.zrt_otm, zrt_tbl.zrt_cld, zrt_tbl.zrt_sts, rtp_tbl.rtp_nme, lng_tbl.lng_lgn FROM zrt_tbl INNER JOIN rtp_tbl ON zrt_tbl.zrt_pid=rtp_tbl.rtp_mid INNER JOIN lng_tbl ON zrt_tbl.zrt_lid=lng_tbl.lng_mid WHERE zrt_tbl.zrt_edt>'%s' AND zrt_tbl.zrt_mid=:zrt_mid"
								,date('U')
							);
			$resz = $dbcn->prepare($sqlz);
			$resz->execute([
							'zrt_mid'=>$val1
						]);

			// fetch the datas from the database into the row variable
			$rowz = $resz->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

		} // select data selection as per the given id close

		// if only 1 row returned the id is valid
		if(isset($rowz) && is_array($rowz) && count($rowz) == 1) {

			// page visit into log
			$this->sbmli($val1, @$_SESSION['urid'], 'Manage zion retreat page delivered', 'zion-retreat', 'zion-retreat-pg');

			// input hiddens for form
			$inhd = $this->inhdn();
			// admin users array function call
			$adar = $this->aduar('zion-retreat');

			// total allocated main members count variable initialize
			$ttam = 0;
			// total supportive main members count variable initialize
			$ttas = 0;
			// main member select options variable initialize
			$mmop = '<option value="">Select main member</option>';

			// select allocated members data to create main member options
			try {

				// allocated members data selection query
				$sqla = sprintf("
									SELECT zam_mid, zam_adi, zam_opt, zam_rtp FROM zam_tbl WHERE zam_zri=:zam_zri AND zam_sts=:zam_sts"
								);
				$resa = $dbcn->prepare($sqla);
				$resa->execute([
								'zam_zri'=>$val1
								,'zam_sts'=>333
							]);

				// fetch the datas from the database into the row variable
				while($rowa = $resa->fetch()) {

					// already allocated member array creation for mysql
					$alea[] = "'" . $rowa['zam_adi'] . "'";

					// if main member
					if($rowa['zam_rtp'] == 111) {

						// total allocated main members count variable increment
						$ttam++;
						// main member select options variable initialize
						$mmop .= sprintf('
											<option value="%s">%s</option>'
											,$rowa['zam_adi']
											,isset($adar[$rowa['zam_adi']])
												?
											$adar[$rowa['zam_adi']]
												:
											'N/A'
										);

					// if supportive member
					} else {

						// total allocated supportive members count variable increment
						$ttas++;

					} // allocated member type check close

				} // allocated members data selection while loop close

			} catch(Exception $e) {

				// error log into file
				$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

			} // select allocated members data close

// page content start tag start
$cont = <<<AAA
			<div class="page-body">

AAA; // page content start tag close

			// retreat name into variable
			$rtnm = $this->zrnrt($rowz[0]);
			// retreat name into variable without html tags
			$rtnt = trim(str_replace(array("\r", "\n"), '', strip_tags($rtnm)));

			// start time into variable
			$sttm = date("d-M-Y, h:i A", $rowz[0]['zrt_sdt']);
			// end time into variable
			$edtm = date("d-M-Y, h:i A", $rowz[0]['zrt_edt']);

			// zion retreat open status variable
			$opst = $rowz[0]['zrt_ost'] == 333
						?
					'<span class="badge badge-success">Opened</span>'
						:
					'<span class="badge badge-danger">Closed</span>';
			// zion retreat closing time variable
			$optm = $rowz[0]['zrt_ost'] == 333
						?
					date('d-M-Y, h:i A', $rowz[0]['zrt_cld'])
						:
					'-';

			// total allocated members into variable
			$ttac = $ttam + $ttas;

// retreat basic info start
$cont .= <<<AAA
             <div class="card">
				 <div class="card-body">
					 <div class="social-details mt-1">
						<h4 class="text-center pb-2 common-border-b" data-aos="zoom-in">$rtnm</h4>
						<ul class="social-follow text-center">
							<li data-aos="slide-right">
								<h5 class="mb-0">$opst</h5>
								<span class="f-light f-12">Open Status</span>
							</li>
							<li data-aos="slide-up">
								<h4 class="mb-0">$ttac <span class="f-12 text-muted">(<small class="f-14 f-w-600 txt-dark">$ttam</small> Main + <small class="f-14 f-w-600 txt-dark">$ttas</small> Supporting)</span></h4>
								<span class="f-light f-12">Allocated Members</span>
							</li>
							<li data-aos="slide-left">
								<h5 class="mb-0">$optm</h5>
								<span class="f-light f-12">Closing On</span>
							</li>
						</ul>
					</div>
				</div>
			</div>

AAA; // retreat basic info close

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-md-8 offset-md-2 col-lg-6 offset-lg-3">
				<div class="card" data-aos="fade-down">

AAA; // card start tag close

			// open button content to close
			if($rowz[0]['zrt_ost'] == 333) {

				// close button content
				$obtn = '<button class="btn btn-danger btn-lg f-w-600 opbt" type="button">Close Zion Retreat</button>';
				// allowed till date and time block display style
				$atdd = 'style="display: none;"';

			// open button content to open
			} else {

				// open button content
				$obtn = '<button class="btn btn-success btn-lg f-w-600 opbt" type="button">Open Zion Retreat</button>';
				// allowed till date and time block display style
				$atdd = '';

			} // open status check for open button content close

			// allowed till date and time
			$atdt = strlen($rowz[0]['zrt_cld']) == 10
						?
					date("d-M-Y, h:i A", $rowz[0]['zrt_cld'])
						:
					date("d-M-Y, h:i A", $rowz[0]['zrt_edt']);

			// retreat name into varaible as text
			$rttx = str_replace("\n", "", trim(strip_tags($rtnm)));

// open button form start
$cont .= <<<AAA
				<form method="post" class="p-2 text-center" id="odfm">

					<div class="mb-3 text-center" $atdd>
						<div class="d-inline-block" style="max-width: 360px;">
							<label for="atdt" class="mb-1">Allowed Till <span class="text-danger">*</span></label>
							<input type="text" class="form-control datdp" id="atdt" name="atdt" aria-describedby="aldthp" placeholder="Enter date & time" value="$atdt" autocomplete="off" required>
							<small id="aldthp" class="form-text text-muted">Enter registration allowed till date & time</small>
						</div>
					</div>

					<input type="hidden" id="sttm" name="sttm" value="$sttm">
					<input type="hidden" id="edtm" name="edtm" value="$edtm">
					<input type="hidden" id="rtnm" name="rtnm" value="$rttx">
					<input type="hidden" id="ossa" name="ossa" value="{$inhd[0]}">
					<input type="hidden" id="ossb" name="ossb" value="{$inhd[1]}">
					<input type="hidden" id="ossc" name="ossc" value="{$inhd[2]}">

					<div class="mt-1"> 
						$obtn
					</div>
				</form>

AAA; // open button form close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

			// admin user select option variable initialize
			$adop = '<option value="">Select admin user</option>';

			// iterate through admin user array
			foreach($adar as $adky => $advl) {

				// if already allocated admin member
				if(isset($alea) && is_array($alea) && in_array("'" . $adky . "'", $alea)) {

				// if not allocated admin member
				} else {

					// admin user select option variable initialize
					$adop .= sprintf('
										<option value="%s" %s>%s</option>'
										,$adky
										,(isset($_POST['rgur']) && $_POST['rgur'] == $adky)
											?
										'selected'
											:
										''
										,$advl
									);

				} // already allocated check close

			} // admin user iteration close

			// allowed date & time variable
			$aldt = isset($_POST['aldt'])
						?
					$_POST['aldt']
						:
					date('d-M-Y, h:i A');
			// allocated member remarks variable
			$amrm = isset($_POST['amrm'])
						?
					$_POST['amrm']
						:
					'';

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-md-12">
				<div class="card" data-aos="fade-down">

AAA; // card start tag close

// card header tag start
$cont .= <<<AAA
					<div class="card-header" data-aos="fade-left">
						<h5 class="f-17 f-w-600">Admin Member Allocation</h5>
					</div>

AAA; // card header tag close

// assign admin form start
$cont .= <<<AAA
					<div class="card-body">
						<form method="post" id="asfm">

							<div class="row">

								<div class="col-sm-6 col-md-4 mb-2">
									<label for="rgur" class="mb-1">Registration User <span class="text-danger">*</span></label>
									<select class="form-control" id="rgur" name="rgur" aria-describedby="rgurhp" required>
										$adop
									</select>
									<small id="rgurhp" class="form-text text-muted">Select registration admin user name</small>
								</div>

								<div class="col-sm-6 col-md-4 mb-2">
									<label for="adtp" class="mb-1 d-block">Admin Type <span class="text-danger">*</span></label>
									<div class="form-check form-check-inline radio radio-primary">
										<input class="form-check-input adtp" id="adt1" type="radio" name="adtp" value="111" required>
										<label class="form-check-label mb-0" for="adt1">Main Member</label>
									</div>
									<div class="form-check form-check-inline radio radio-primary">
										<input class="form-check-input adtp" id="adt2" type="radio" name="adtp" value="222" required>
										<label class="form-check-label mb-0" for="adt2">Badge Distributor</label>
									</div>
									<div class="form-check form-check-inline radio radio-primary">
										<input class="form-check-input adtp" id="adt3" type="radio" name="adtp" value="333" required>
										<label class="form-check-label mb-0" for="adt3">Fee Collector</label>
									</div>
									<small id="adtphp" class="form-text text-muted d-block">Main user is the one with computer, rest is supporting</small>
								</div>

								<div class="col-sm-6 col-md-4 mb-2 mnmb" style="display: none;">
									<label for="amnm" class="mb-1">Main Member <span class="text-danger">*</span></label>
									<select class="form-control" id="amnm" name="amnm" aria-describedby="amnmhp">
										$mmop
									</select>
									<small id="amnmhp" class="form-text text-muted">Select main member of the current supporting member</small>
								</div>

								<div class="col-sm-6 col-md-4 mb-2">
									<label for="aldt" class="mb-1">Allowed From <span class="text-danger">*</span></label>
									<input type="text" class="form-control datdp" id="aldt" name="aldt" aria-describedby="aldthp" placeholder="Enter date & time" value="$aldt" autocomplete="off" required>
									<small id="aldthp" class="form-text text-muted">Enter registration allowed from date & time</small>
								</div>

								<div class="col-sm-6 col-md-4 mb-2">
									<label for="amrm" class="mb-1">Remarks</label>
									<textarea class="form-control" id="amrm" name="amrm" aria-describedby="amrmhp" placeholder="Enter allocated member remarks" autocomplete="off">$amrm</textarea>
									<small id="amrmhp" class="form-text text-muted">Enter allocated member remarks/notes</small>
								</div>

							</div>

							<input type="hidden" id="rtnt" name="rtnt" value="$rtnt">
							<input type="hidden" id="assa" name="assa" value="{$inhd[0]}">
							<input type="hidden" id="assb" name="assb" value="{$inhd[1]}">
							<input type="hidden" id="assc" name="assc" value="{$inhd[2]}">

							<div class="mt-2"> 
								<button class="btn btn-primary" type="submit">Save</button>
							</div>
						</form>
					</div>

AAA; // assign admin form close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-md-12">
				<div class="card">

AAA; // card start tag close

// card header tag start
$cont .= <<<AAA
					<div class="card-header" data-aos="fade-left" data-aos-once="true">
						<h5 class="f-17 f-w-600">Allocated Admin Members</h5>
					</div>

AAA; // card header tag close

	// call allocated member list into variable
	$allt = $this->mgzal($rtnt, 'zion-retreat', 111);
	// allocated member list content length check
	$alml = strlen($allt) > 20
				?
			$allt
				:
			'<span class="txt-danger">No allocated members found</span>';

// card body tag start
$cont .= <<<AAA
					<div class="card-body">
						$alml
					</div>

AAA; // card body tag close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

// page content close tag start
$cont .= <<<AAA
			</div>

AAA; // page content close tag close

// edit allocation modal start
$cont .= <<<AAA
	<div class="modal fade" id="edtam" role="dialog" aria-labelledby="edtam" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="nrgtt" data-aos="fade-left">Edit Member Allocation</h4>
					<button class="btn-close py-0" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
				</div>
			</div>
		</div>
	</div>

AAA; // edit allocation modal close
echo $cont;

		} // row count check close

	} // get value check close

}
// mgzrs - manage zion retreat actions submit
function mgzrs() {

	// alert message variable initialize
	$alms = '';

	// open/close form submit
	if(isset($_POST['ossa'])) {

		// mgzos - manage zion retreat open status update submit
		$alms = $this->mgzos();

	// allocate admin member form submit
	} else if(isset($_POST['assa'])) {

		// mgzas - manage zion retreat allocate member submit
		$alms = $this->mgzas();

	// delete allocated admin member form submit
	} else if(isset($_POST['dssa'])) {

		// mgzds - manage zion retreat delete allocated member submit
		$alms = $this->mgzds();

	} // form submit type check close

	// return alert message variable
	return $alms;

}
// mgzrc - manage zion retreat additional css content
function mgzrc() {

	// datpc - date & time picker css initialize call
	$this->datpc();
	// aoscs - aos animation css initialize call
	$this->aoscs();

// additional css start
$cont = <<<AAA
	<style>
		.dlt--btn {
			width: 17px;
			height: 17px;
		}
		.act--btn {
			padding: 4px 8px!important;
		}
	</style>

AAA; // additional css close
echo $cont;

}
// mgzrj - manage zion retreat additional js content
function mgzrj() {

	// datpj - date & time picker js initialize call
	$this->datpj();
	// aosjs - aos animation js initialize call
	$this->aosjs();

// main member block display start
$cont = <<<'AAA'
	<script>
		$(".adtp").on("change", function(){
			if($('.adtp:checked').val() > 111) {
				$('.mnmb').show(150);
				$('#amnm').prop('required', true);
			} else {
				$('.mnmb').hide(150);
				$('#amnm').prop('required', false);
			}
		});
	</script>

AAA; // main member block display close

// open zion retreat button confirm start
$cont .= <<<'AAA'
	<script>
		$(document).ready(function(){
			$(".opbt").on("click", function(e){
				e.preventDefault();
				Swal.fire({
					icon: 'info',
					title: 'Confirm Action',
					html: 'Do you really want to ' + $(".opbt").text().toLowerCase() + '?',
					confirmButtonColor: '#45afd2',
					confirmButtonText: 'Yes',
					showCancelButton: true,
					cancelButtonText: 'No',
				}).then((result) => {
					if(result.isConfirmed) {
						$("#odfm").submit();
					}
				});
			});
		});
	</script>

AAA; // open zion retreat button confirm close

// edit allocation start
$cont .= <<<'AAA'
		<script>
			$(document).ready(function(){
				$(".edbt").on("click", function(){
					var fmct = new FormData();
					fmct.append('idtf', '6422');
					fmct.append('amid', $(this).attr('data-amid'));
					$.ajax({
						type: "POST",
						url: "load",
						data: fmct,
						processData: false,
						contentType: false,
						success: function(rmsg){
							var jddt = jQuery.parseJSON(rmsg);
							if(jddt.sts == 333) {
								$('#edtam .modal-body').html(jddt.cnt);
								$('#edtam').modal('show');
							} else {
								Swal.fire({
									icon: 'error',
									title: 'Action Failed',
									text: jddt.cnt,
									confirmButtonColor: '#cc2f26'
								});
							}
						}
					});
				});
			});
		</script>

AAA; // edit allocation close

// delete allocated member button confirm start
$cont .= <<<'AAA'
	<script>
		$(document).ready(function(){
			$(".dlbt").on("click", function(e){
				e.preventDefault();
				Swal.fire({
					icon: 'info',
					title: 'Confirm Deletion',
					html: 'Do you really want to delete the allocated member <span class="txt-secondary f-w-600">' + $(this).attr('data-mbnm') + '</span>?',
					confirmButtonColor: '#45afd2',
					confirmButtonText: 'Yes',
					showCancelButton: true,
					cancelButtonText: 'No',
				}).then((result) => {
					if(result.isConfirmed) {
						$(this).parents('form').submit();
					}
				});
			});
		});
	</script>

AAA; // delete allocated member button confirm close
echo $cont;

}


// ------- manage zion retreat supporting functions -------
// mgzos - open status update submit
function mgzos() {
GLOBAL $dbcn;

	// if form is submitted and conditions satisfied
	if(isset($_POST['ossa'], $_POST['ossb'], $_POST['ossc']) && $_POST['ossc'] == md5("|=".($_POST['ossb']-333)."=|")) {

		// val1 into variable
		$val1 = $_GET['val1'];

		// page visit into log
		$this->sbmli($val1, @$_SESSION['urid'], 'Zion retreat open/close form submit requested', 'zion-retreat', 'zion-retreat-pg');

		// if form is accidently submitted
		if(isset($_POST['ossa'],$_SESSION['fmck']) && $_SESSION['fmck'] == $_POST['ossa']) {

		// if form is freshly submitted
		} else {

			// rteck - retreat id named table exists check
			$this->rteck($val1);

			// select zion retreat data
			try {

				// select zion retreat data query
				$sqls = "SELECT zrt_ost FROM zrt_tbl WHERE zrt_mid=:zrt_mid";
				$ress = $dbcn->prepare($sqls);
				$ress->execute([
								'zrt_mid'=>$val1
							]);

				// fetch the datas from the database into the row variable
				$rows = $ress->fetchAll();

			} catch(Exception $e) {

				// error log into file
				$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

			} // select zion retreat data

			// row count is 1 means valid data
			if(isset($rows) && is_array($rows) && count($rows) == 1) {

				// page visit into log
				$this->sbmli($val1, @$_SESSION['urid'], 'Zion retreat open/close form submit requested, valid zion retreat', 'zion-retreat', 'zion-retreat-pg');

				// update zion retreat open data in database
				try {

					// zion retreat open update query
					$sqlg = "UPDATE zrt_tbl SET zrt_ost=:zrt_ost, zrt_cld=:zrt_cld, zrt_sys=:zrt_sys, zrt_otm=:zrt_otm, zrt_mdt=:zrt_mdt, zrt_mdu=:zrt_mdu, zrt_mds=:zrt_mds WHERE zrt_mid=:zrt_mid";
					$resg = $dbcn->prepare($sqlg);
					$resg->execute([
									'zrt_ost'=>$rows[0]['zrt_ost'] == 333
													?
												999
													:
												333
									,'zrt_cld'=>strtotime($_POST['atdt'])
									,'zrt_sys'=>999
									,'zrt_otm'=>date('U')
									,'zrt_mdt'=>date('U')
									,'zrt_mdu'=>$_SESSION['urid']
									,'zrt_mds'=>$_SESSION['snid']
									,'zrt_mid'=>$val1
								]);

					// retreat open title
					$rtot = $rows[0]['zrt_ost'] == 333
								?
							'Zion Retreat Closed'
								:
							'Zion Retreat Opened';
					// retreat open description
					$rtdc = $rows[0]['zrt_ost'] == 333
								?
							'Zion retreat successfully closed'
								:
							'Zion retreat successfully opened';

					// alert message into variable
					$alrt = sprintf("
										<script>
											Swal.fire({
												icon: 'success',
												title: '%s',
												html: '%s',
												confirmButtonColor: '#45afd2',
												confirmButtonText: 'Ok',
												allowOutsideClick: false,
												allowEscapeKey: false
											}).then((result) => {
												window.location.href = window.location.href;
											});
										</script>"
										,$rtot
										,$rtdc
									);

					// admin users array
					$adar = $this->aduar('zion-retreat');

					// actar - action types array
					$acar = $this->actar();
					// action text into variable
					$actx = str_replace(
										'###'
										,($rows[0]['zrt_ost'] == 333 ? 'Closed' : 'Opened')
										,str_replace(
											'***'
											,$_POST['rtnm']
											,$acar[1101]
										)
									);

					// action log save function call
					$this->actli($val1, 1101, $_SESSION['urid'], $actx, 'zion-retreat', 'zion-retreat-pg');

					// select allocated members data query
					$sqla = "SELECT zam_adi FROM zam_tbl WHERE zam_zri=:zam_zri AND zam_sts=:zam_sts";
					$resa = $dbcn->prepare($sqla);
					$resa->execute([
									'zam_zri'=>$val1
									,'zam_sts'=>333
								]);

					// fetch the datas from the database into the row variable
					while($rowa = $resa->fetch()) {

						// allocated admin ids into array
						$amar[] = $rowa['zam_adi'];

					} // allocated members array iteration close

					// if zion retreat closed, cancel notifications, 333 is before changed status, so it's actually 999 now
					if($rows[0]['zrt_ost'] == 333) {

						// check allocated members array exists or not
						if(isset($amar) && is_array($amar) && count($amar) > 0) {

							// iterate through allocated members array
							foreach($amar as $amky => $amvl) {

								// call cancel notification function
								$this->ntfcs(1101, $val1, $amvl, 'zion-retreat');

							} // allocated members array iteration close

						} // allocated members array exists check close

					} // zion retreat open status check for notification cancel close

					// if zion retreat opened, send notification, 999 is before changed status, so it's actually 333 now
					if($rows[0]['zrt_ost'] == 999) {

						// check allocated members array exists or not
						if(isset($amar) && is_array($amar) && count($amar) > 0) {

							// iterate through allocated members array
							foreach($amar as $amky => $amvl) {

								// notification title into variable
								$nttl = 'Your assigned Zion Retreat has been opened for registration';
								// notification URL into variable
								$ntur = 'new-registration/' . $val1 . '/' . $_GET['val2'];

								// notification content array making
								$ntca = array(
												'rtnm'=>$_POST['rtnm']
												,'optm'=>$_POST['atdt']
												,'sttm'=>$_POST['sttm']
												,'edtm'=>$_POST['edtm']
												,'lkur'=>$ntur
											);
								// notification content making
								$nfct = $this->nftcm(1101, $val1, $ntca);
								// sender admin user name into variable
								$sdnm = isset($adar[$_SESSION['urid']])
											?
										$adar[$_SESSION['urid']]
											:
										'N/A';

								// call send notification function
								$this->ntfis($nttl, $ntur, 1101, $val1, $nfct, $_SESSION['urtp'], $_SESSION['urid'], $sdnm, $amvl, 999, 333, 333, 'zion-retreat');

							} // allocated members array iteration close

						} // allocated members array exists check close

					} // zion retreat status check for notification send close

				} catch(Exception $e) {

					// error log into file
					$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

				} // update zion retreat open data close

			} // data row count check close

			// set the variable for the accident form submit
			$_SESSION['fmck'] = $_POST['ossa'];

			// return alert message
			return $alrt;

		} // form accidently submitted check close

	} // form submitted check close

}
// mgzas - allocate member submit
function mgzas() {
GLOBAL $dbcn;

	// if form is submitted and conditions satisfied
	if(isset($_POST['assa'], $_POST['assb'], $_POST['assc']) && $_POST['assc'] == md5("|=".($_POST['assb']-333)."=|")) {

		// val1 into variable
		$val1 = $_GET['val1'];

		// page visit into log
		$this->sbmli($val1, @$_SESSION['urid'], 'Zion retreat member allocate form submitted', 'zion-retreat', 'zion-retreat-pg');

		// if form is accidently submitted
		if(isset($_POST['assa'],$_SESSION['fmck']) && $_SESSION['fmck'] == $_POST['assa']) {

		// if form is freshly submitted
		} else {

			// initialize alert message variable
			$alrt = '';

			// retreat name input format
			$rtnt = $this->inpvl($_POST['rtnt'],0,'',0);
			// allocated member admin id input format
			$rgur = $this->inpvl($_POST['rgur'],0,'',0);
			// allocated member type input format
			$adtp = $this->inpvl($_POST['adtp'],0,'',0);
			// allocated main member admin id input format
			$amnm = $this->inpvl($_POST['amnm'],0,'',0);
			// allocated member from date input format
			$aldt = $this->inpvl($_POST['aldt'],0,'',0);
			// allocated member remarks input format
			$amrm = $this->inpvl($_POST['amrm'],0,'',0);

			// admin users array function call
			$adar = $this->aduar('zion-retreat');

			// admin user name into variable
			$adun = isset($adar[$rgur])
						?
					$adar[$rgur]
						:
					'N/A';
			// allocated user type into variable
			$altp = $adtp == 111
						?
					'Main Member'
						:
					'Supporting Member';

			// select existing allocated member data
			try {

				// select existing allocated member data query
				$sqlc = "SELECT zam_mid FROM zam_tbl WHERE zam_zri=:zam_zri AND zam_adi=:zam_adi AND zam_sts=:zam_sts";
				$resc = $dbcn->prepare($sqlc);
				$resc->execute([
								'zam_zri'=>$val1
								,'zam_adi'=>$rgur
								,'zam_sts'=>333
							]);

				// fetch the datas from the database into the row variable
				$rowc = $resc->fetchAll();

			} catch(Exception $e) {

				// error log into file
				$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

			} // select existing allocated member data

			// row count is greater than 1, data exists
			if(isset($rowc) && is_array($rowc) && count($rowc) > 0) {

				// page visit into log
				$this->sbmli($val1, @$_SESSION['urid'], 'Zion retreat member allocate form submitted, member already assigned - ' . $rowc[0]['zam_mid'], 'zion-retreat', 'zion-retreat-pg');

				// alert message into variable
				$alrt = sprintf("
									<script>
										Swal.fire({
											icon: 'error',
											title: 'Already Allocated',
											html: '<div>Admin member already allocated to the zion retreat</div><table class=\'table mb-0\'><tbody><tr><td class=\'text-end f-14\'>Admin Member:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr><tr><td class=\'text-end f-14\'>Allocation Type:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr></tr></tbody></table>',
											confirmButtonColor: '#45afd2',
											confirmButtonText: 'Ok',
											allowOutsideClick: false,
											allowEscapeKey: false,
										}).then((result) => {
											window.location.href = window.location.href;
										});
									</script>"
									,$adun
									,$altp
								);

			// if no row found, fresh to add
			} else {

				// insert zion retreat allocated member data in database
				try {

					// zion retreat allocated member insert query
					$sqlg = "INSERT INTO zam_tbl(zam_zri, zam_adi, zam_opt, zam_rtp, zam_mmi, zam_rmk, zam_sys, zam_sts, zam_adt, zam_mdt, zam_adu, zam_mdu, zam_ads, zam_mds) VALUES (:zam_zri, :zam_adi, :zam_opt, :zam_rtp, :zam_mmi, :zam_rmk, :zam_sys, :zam_sts, :zam_adt, :zam_mdt, :zam_adu, :zam_mdu, :zam_ads, :zam_mds)";
					$resg = $dbcn->prepare($sqlg);
					$resg->execute([
								'zam_zri'=>$_GET['val1']
								,'zam_adi'=>$rgur
								,'zam_opt'=>strtotime($aldt)
								,'zam_rtp'=>$adtp
								,'zam_mmi'=>($amnm > 100000 && $adtp == 222)
												?
											$amnm
												:
											$rgur
								,'zam_rmk'=>$amrm
								,'zam_sys'=>999
								,'zam_sts'=>333
								,'zam_adt'=>date('U')
								,'zam_mdt'=>date('U')
								,'zam_adu'=>$_SESSION['urid']
								,'zam_mdu'=>$_SESSION['urid']
								,'zam_ads'=>$_SESSION['snid']
								,'zam_mds'=>$_SESSION['snid']
								]);

					// alert message into variable
					$alrt = sprintf("
									<script>
										Swal.fire({
											icon: 'success',
											title: 'Admin Allocated',
											html: '<div>Admin member successfully allocated to the zion retreat</div><table class=\'table mb-0\'><tbody><tr><td class=\'text-end f-14\'>Admin Member:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr><tr><td class=\'text-end f-14\'>Allocation Type:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr></tr></tbody></table>',
											confirmButtonColor: '#45afd2',
											confirmButtonText: 'Ok',
											allowOutsideClick: false,
											allowEscapeKey: false,
										}).then((result) => {
											window.location.href = window.location.href;
										});
									</script>"
									,$adun
									,$altp
								);

					// notification title into variable
					$nttl = 'You have assigned to a zion retreat for registration';
					// notification URL into variable
					$ntur = 'new-registration/' . $val1 . '/' . $_GET['val2'];

					// notification content array making
					$ntca = array(
									'rtnm'=>$rtnt
								);
					// notification content making
					$nfct = $this->nftcm(1102, $val1, $ntca);
					// sender admin user name into variable
					$sdnm = isset($adar[$_SESSION['urid']])
								?
							$adar[$_SESSION['urid']]
								:
							'N/A';

					// call send notification function
					$this->ntfis($nttl, $ntur, 1102, $val1, $nfct, $_SESSION['urtp'], $_SESSION['urid'], $sdnm, $rgur, 999, 333, 333, 'zion-retreat');

					// last inserted admin id
					$lsid = $dbcn->lastInsertId();

					// actar - action types array
					$acar = $this->actar();
					// action text into variable
					$actx = str_replace('###', $adun, str_replace('***', $rtnt, $acar[1102]));

					// action log save function call
					$this->actli($lsid, 1102, $_SESSION['urid'], $actx, 'zion-retreat', 'zion-retreat-pg');

				} catch(Exception $e) {

					// error log into file
					$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

				} // insert zion retreat allocated member data close

			} // data row count check close

			// set the variable for the accident form submit
			$_SESSION['fmck'] = $_POST['assa'];

			// return alert message
			return $alrt;

		} // form accidently submitted check close

	} // form submitted check close

}
// mgzal - allocated member list html content
function mgzal($rtnt, $pgnm, $rett) {
GLOBAL $dbcn;

	// rtnt-retreat name, pgnm-page name, rett-return type for setting col- & button show

	// function to create member block
	function member_block_make($mbar, $inhd, $rett, $rtnt) {
	GLOBAL $wpfx;

		// add into list
		$mblt = sprintf('
							<div class="%s mt-2">
								<div class="card" style="box-shadow: 0px 7px 21px rgb(0 0 0 / 15%s);">
									<div class="card-body designer-card">
										<div>
											<div class="d-flex align-items-center gap-2">
												<div class="flex-shrink-0"><img src="static/assets/prpic/ps/%s" class="img-40" alt="%s"></div>
												<div class="flex-grow-1">
													<a href="%spreview-member/%s/%s" target="_blank">
														<h5>%s <small class="f-12 text-muted">(%s)</small></h5>
													</a>
													<p>%s</p>
												</div>
											</div>
											<div class="design-button">
												<button class="btn bg-light-%s btn-sm font-%s f-w-500">%s</button>'
							,$rett == 111
								?
							'col-xl-3 col-lg-4 col-md-6'
								:
							'col-xl-4 col-lg-6'
							,'%'
							,(!is_null($mbar['mbr_iur']) && strlen($mbar['mbr_iur']) > 4)
								?
							'ps' . $mbar['mbr_iur']
								:
							(
								$mbar['mbr_gdr'] == 111
									?
								'psmale-avatar.jpg'
									:
								'psfemale-avatar.jpg'
							)
							,$mbar['mbr_knn']
							,$wpfx
							,$mbar['mbr_mid']
							,md5("^#" . $mbar['mbr_mid'] . "#^")
							,$mbar['mbr_knn']
							,$mbar['mbr_gdr'] == 111
								?
							'M'
								:
							'F'
							,$mbar['fsp_nme']
							,$mbar['zam_rtp'] == 111
								?
							'primary'
								:
							(
								$mbar['zam_rtp'] == 222
									?
								'secondary'
									:
								'warning'
							)
							,$mbar['zam_rtp'] == 111
								?
							'primary'
								:
							(
								$mbar['zam_rtp'] == 222
									?
								'secondary'
									:
								'warning'
							)
							,$mbar['zam_rtp'] == 111
								?
							'Main Member'
								:
							(
								$mbar['zam_rtp'] == 222
									?
								'Badge Distributor'
									:
								'Fee Collector'
							)
						);

		// if delete button required
		if($rett == 111) {

			// add into list
			$mblt .= sprintf('<div class="float-end">');

			// add into list
			$mblt .= sprintf('
								<button class="btn btn-sm bg-light-success act--btn font-success f-w-500 edbt d-inline-block" data-amid="%s"><i data-feather="edit" class="dlt--btn"></i></button>'
								,$mbar['zam_mid']
							);

			// add into list
			$mblt .= sprintf('
								<form method="post" class="d-inline-block">
									<input type="hidden" name="dlrn" id="dlrn" value="%s">
									<input type="hidden" name="dlai" id="dlai" value="%s">
									<input type="hidden" name="dlmn" id="dlmn" value="%s">
									<input type="hidden" name="dlid" id="dlid" value="%s">
									<input type="hidden" name="dssa" id="dssa" value="%s">
									<input type="hidden" name="dssb" id="dssb" value="%s">
									<input type="hidden" name="dssc" id="dssc" value="%s">
									<button class="btn btn-sm bg-light-danger act--btn ms-1 font-danger f-w-500 dlbt" data-mbnm="%s"><i data-feather="trash-2" class="dlt--btn"></i></button>
								</form>'
								,$rtnt
								,$mbar['zam_adi']
								,$mbar['mbr_knn']
								,$mbar['zam_mid']
								,$inhd[0]
								,$inhd[1]
								,$inhd[2]
								,$mbar['mbr_knn']
							);

			// add into list
			$mblt .= sprintf('</div>');

		} // delete button needed or not check close

		// add into list
		$mblt .= sprintf('
											</div>
										</div>
									</div>
								</div>
							</div>'
						);

		// return member list
		return $mblt;

	}

	// input hiddens for form
	$inhd = $this->inhdn();

	// initialize list varaible
	$zral = '';
	// team count varaible initialize
	$tmct = 0;
	// allocated member count varaible initialize
	$amct = 0;

	// val1 into variable
	$val1 = $_GET['val1'];

	// page visit into log
	$this->sbmli($val1, @$_SESSION['urid'], 'Zion retreat allocated members list requested', $pgnm, $pgnm . '-pg');

	// select zion retreat assigned members data
	try {

		// zion retreat assigned members data selection query
		$sqla = "SELECT zrt_tbl.zrt_mid, zam_tbl.zam_mid, zam_tbl.zam_adi, zam_tbl.zam_rtp, zam_tbl.zam_mmi, mbr_bsc.mbr_mid, mbr_bsc.mbr_knn, mbr_bsc.mbr_gdr, mbr_bsc.mbr_iur, loc_fsp.fsp_nme FROM zam_tbl INNER JOIN zrt_tbl ON zam_tbl.zam_zri=zrt_tbl.zrt_mid INNER JOIN adm_usr ON zam_tbl.zam_adi=adm_usr.adm_mid INNER JOIN mbr_bsc ON adm_usr.adm_mbi=mbr_bsc.mbr_mid INNER JOIN loc_fsp ON mbr_bsc.mbr_fid=loc_fsp.fsp_mid WHERE zam_tbl.zam_sts=:zam_sts AND zrt_tbl.zrt_mid=:zrt_mid ORDER BY zam_tbl.zam_mmi ASC, zam_tbl.zam_rtp ASC, mbr_bsc.mbr_knn ASC";
		$resa = $dbcn->prepare($sqla);
		$resa->execute([
						'zam_sts'=>333
						,'zrt_mid'=>$val1
					]);

		// fetch the datas from the database into the row variable
		while($rowa = $resa->fetch()) {

			// allocated member count varaible increment
			$amct++;

			// if existing main user id reached
			if(isset($emmi) && $emmi == $rowa['zam_mmi']) {

				// add into list
				$zral .= member_block_make($rowa, $inhd, $rett, $rtnt);

			// if new main user id reached
			} else {

				// if count greater than 1, then close opened row class
				if($amct > 1) {

					// add into list
					$zral .= '</div>';

				} // count for close tag check close

				// team count varaible increment
				$tmct++;
				// main member id into variable
				$emmi = $rowa['zam_mmi'];
				// add into list
				$zral .= sprintf('
									<h5 class="f-w-600 text-muted %s pt-2 %s">Team %s</h5>
									<div class="row">'
									,$rett == 111
										?
									''
										:
									'mt-3'
									,$amct > 1
										?
									'common-border-t'
										:
									''
									,$tmct
								);
				// add into list
				$zral .= member_block_make($rowa, $inhd, $rett, $rtnt);

			} // main user id checking close

		} // assigned members select while loop close

	} catch(Exception $e) {

		// error log into file
		$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), $pgnm, $pgnm . '-pg');

	} // select zion retreat assigned members data close

	// return list variable
	return $zral . '</div>';

}
// mbamd - allocated member edit modal html content
function mbamd($amid) {
GLOBAL $dbcn;

	// page visit into log
	$this->sbmli($amid, @$_SESSION['urid'], 'allocated member modal form content requested', 'zion-retreat', 'zion-retreat-pg');

	// initialize return array, content
	$rtar['cnt'] = 'Invalid member allocation id, try again';
	// initialize return array, status
	$rtar['sts'] = 999;

	// select existing allocated member data
	try {

		// select existing allocated member data query
		$sqla = "SELECT zam_tbl.zam_opt, zam_tbl.zam_rtp, zam_tbl.zam_mmi, zam_tbl.zam_rmk, zam_tbl.zam_sts, mbr_bsc.mbr_knn, mbr_zid.mzi_zid FROM zam_tbl INNER JOIN adm_usr ON zam_tbl.zam_adi=adm_usr.adm_mid INNER JOIN mbr_bsc ON adm_usr.adm_mbi=mbr_bsc.mbr_mid INNER JOIN mbr_zid ON mbr_bsc.mbr_mid=mbr_zid.mzi_mbi WHERE zam_tbl.zam_mid=:zam_mid AND zam_tbl.zam_sts=:zam_sts";
		$resa = $dbcn->prepare($sqla);
		$resa->execute([
						'zam_mid'=>$amid
						,'zam_sts'=>333
					]);

		// fetch the datas from the database into the row variable
		$rowa = $resa->fetchAll();

	} catch(Exception $e) {

		// error log into file
		$this->errli($amid, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

	} // select existing allocated member data

	// if valid allocated Member
	if(isset($rowa) && is_array($rowa) && count($rowa) == 1) {

		// input hiddens for form
		$inhd = $this->inhdn();

		// member block into variable
		$mbbk = str_replace("col-sm-6 col-md-4", "col-sm-8 col-md-6", $this->ftmdr($rowa[0]['mzi_zid'], 'zion-retreat'));
		// allowed from date into variable
		$aldt = date("d-M-Y, h:i A", $rowa[0]['zam_opt']);
		// allocation remark into variable
		$amrm = $rowa[0]['zam_rmk'];
		// member name into variable
		$mbnm = $rowa[0]['mbr_knn'];

$cont = <<<AAA
	<form method="post" id="asfm">

		<div class="row">

			<div class="col-sm-12 mb-2">
				<label for="rgur" class="mb-1">Registration User <span class="text-danger">*</span></label>
				$mbbk
				<small id="rgurhp" class="form-text text-muted">Select registration admin user name</small>
			</div>

			<div class="col-sm-6 col-md-6 mb-2">
				<label for="adtp" class="mb-1 d-block">Admin Type <span class="text-danger">*</span></label>
				<div class="form-check form-check-inline radio radio-primary">
					<input class="form-check-input adtp" id="adt1" type="radio" name="adtp" value="111" required>
					<label class="form-check-label mb-0" for="adt1">Main Member</label>
				</div>
				<div class="form-check form-check-inline radio radio-primary">
					<input class="form-check-input adtp" id="adt2" type="radio" name="adtp" value="222" required>
					<label class="form-check-label mb-0" for="adt2">Badge Distributor</label>
				</div>
				<div class="form-check form-check-inline radio radio-primary">
					<input class="form-check-input adtp" id="adt3" type="radio" name="adtp" value="333" required>
					<label class="form-check-label mb-0" for="adt3">Fee Collector</label>
				</div>
				<small id="adtphp" class="form-text text-muted d-block">Main user is the one with computer, rest is supporting</small>
			</div>

			<div class="col-sm-6 col-md-6 mb-2 mnmb" style="display: none;">
				<label for="amnm" class="mb-1">Main Member <span class="text-danger">*</span></label>
				<select class="form-control" id="amnm" name="amnm" aria-describedby="amnmhp">
					
				</select>
				<small id="amnmhp" class="form-text text-muted">Select main member of the current supporting member</small>
			</div>

			<div class="col-sm-6 col-md-6 mb-2">
				<label for="aedt" class="mb-1">Allowed From <span class="text-danger">*</span></label>
				<input type="text" class="form-control datdp" id="aedt" name="aldt" aria-describedby="aedthp" placeholder="Enter date & time" value="$aldt" autocomplete="off" required>
				<small id="aedthp" class="form-text text-muted">Enter registration allowed from date & time</small>
			</div>

			<div class="col-sm-6 col-md-6 mb-2">
				<label for="aerm" class="mb-1">Remarks</label>
				<textarea class="form-control" id="aerm" name="amrm" aria-describedby="aermhp" placeholder="Enter allocated member remarks" autocomplete="off">$amrm</textarea>
				<small id="aermhp" class="form-text text-muted">Enter allocated member remarks/notes</small>
			</div>

		</div>

		<input type="hidden" id="mbnm" name="mbnm" value="$mbnm">
		<input type="hidden" id="assa" name="assa" value="{$inhd[0]}">
		<input type="hidden" id="assb" name="assb" value="{$inhd[1]}">
		<input type="hidden" id="assc" name="assc" value="{$inhd[2]}">

		<div class="mt-2"> 
			<button class="btn btn-primary" type="submit">Save</button>
		</div>
	</form>

AAA;

		// return array, content replace
		$rtar['cnt'] = $cont;
		// return array, status to success
		$rtar['sts'] = 333;

		// page visit into log
		$this->sbmli($amid, @$_SESSION['urid'], 'allocated member modal form content delivered', 'zion-retreat', 'zion-retreat-pg');

	} // allocation check close

	// echo json encoded array
	echo json_encode($rtar);

}
// mgzds - delete allocated member submit
function mgzds() {
GLOBAL $dbcn;

	// if form is submitted and conditions satisfied
	if(isset($_POST['dssa'], $_POST['dssb'], $_POST['dssc'], $_POST['dlid'], $_POST['dlmn']) && $_POST['dssc'] == md5("|=".($_POST['dssb']-333)."=|")) {

		// val1 into variable
		$val1 = $_GET['val1'];
		// zion retreat name into variable
		$dlrn = $_POST['dlrn'];
		// allocated member table id into variable
		$dlid = $_POST['dlid'];
		// member name into variable
		$dlmn = $_POST['dlmn'];
		// admin id into variable
		$dlai = $_POST['dlai'];

		// page visit into log
		$this->sbmli($dlid, @$_SESSION['urid'], 'Zion retreat allocated member delete form submitted', 'zion-retreat', 'zion-retreat-pg');

		// initialize alert message variable
		$alrt = '';

		// select existing allocated member data
		try {

			// select existing allocated member data query
			$sqlc = "SELECT zam_mid FROM zam_tbl WHERE zam_zri=:zam_zri AND zam_mmi=:zam_mmi AND zam_sts=:zam_sts AND (zam_mmi!=zam_adi)";
			$resc = $dbcn->prepare($sqlc);
			$resc->execute([
							'zam_zri'=>$val1
							,'zam_mmi'=>$dlai
							,'zam_sts'=>333
						]);

			// fetch the datas from the database into the row variable
			$rowc = $resc->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

		} // select existing allocated member data

		// member have sub member, can't delete
		if(isset($rowc) && is_array($rowc) && count($rowc) > 0) {

			// add into alert message
			$alrt = sprintf("
								<script>
									Swal.fire({
										icon: 'error',
										title: 'Deletion Failed',
										html: 'Selected member <span class=\"txt-secondary f-w-600\">%s</span> have supporting members, delete supporting members first.',
										confirmButtonColor: '#cc2f26',
										allowOutsideClick: false,
										allowEscapeKey: false
									}).then((result) => {
										window.location.href = window.location.href;
									});
								</script>"
								,$dlmn
							);

		// member don't have sub members can be deleted
		} else {

			// update existing allocated member data
			try {

				// update existing allocated member data query
				$sqlu = "UPDATE zam_tbl SET zam_sys=:zam_sys, zam_sts=:zam_sts, zam_mdt=:zam_mdt, zam_mdu=:zam_mdu, zam_mds=:zam_mds WHERE zam_mid=:zam_mid";
				$resu = $dbcn->prepare($sqlu);
				$resu->execute([
								'zam_sys'=>999
								,'zam_sts'=>999
								,'zam_mdt'=>date("U")
								,'zam_mdu'=>$_SESSION['urid']
								,'zam_mds'=>$_SESSION['snid']
								,'zam_mid'=>$dlid
							]);

				// add into alert message
				$alrt = sprintf("
									<script>
										Swal.fire({
											icon: 'success',
											title: 'Allocated Member Removed',
											html: 'Allocated member <span class=\"txt-secondary f-w-600\">%s</span> has been successfully removed from allocation',
											confirmButtonColor: '#4c9a4a',
											allowOutsideClick: false,
											timer: 3000,
											timerProgressBar: true,
											allowEscapeKey: false
										}).then((result) => {
											window.location.href = window.location.href;
										});
									</script>"
									,$dlmn
								);

				// call cancel notification function
				$this->ntfcs(1102, $val1, $dlai, 'zion-retreat');

				// actar - action types array
				$acar = $this->actar();
				// action text into variable
				$actx = str_replace('###', $dlmn, str_replace('***', $dlrn, $acar[1103]));

				// action log save function call
				$this->actli($dlid, 1103, $_SESSION['urid'], $actx, 'zion-retreat', 'zion-retreat-pg');

			} catch(Exception $e) {

				// error log into file
				$this->errli($dlid, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

			} // update existing allocated member data

		} // member have sub members check close

		// return alert message
		return $alrt;

	} // form submitted check close

}

// ------- preview zion retreat functions -------
// pwzrt - preview zion retreat html content
function pwzrt() {
GLOBAL $dbcn, $wpfx, $upar;

	// check get value and hash are matching
	if(isset($_GET['val1'], $_GET['val2']) && $_GET['val2'] == md5("^#" . $_GET['val1'] . "#^")) {

		// val1 into variable
		$val1 = $_GET['val1'];
		// val2 into variable
		$val2 = $_GET['val2'];

		// page visit into log
		$this->sbmli($val1, @$_SESSION['urid'], 'Preview zion retreat page requested', 'zion-retreat', 'zion-retreat-pg');

		// select zion retreat data as per given id from database
		try {

			// zion retreat data selection query
			$sqlz = "SELECT zrt_tbl.zrt_mid, zrt_tbl.zrt_pid, zrt_tbl.zrt_sdt, zrt_tbl.zrt_edt, zrt_tbl.zrt_act, zrt_tbl.zrt_cct, zrt_tbl.zrt_lid, zrt_tbl.zrt_tns, zrt_tbl.zrt_rmk, zrt_tbl.zrt_ost, zrt_tbl.zrt_cld, zrt_tbl.zrt_otm, zrt_tbl.zrt_sts, zrt_tbl.zrt_adt, zrt_tbl.zrt_mdt, zrt_tbl.zrt_adu, zrt_tbl.zrt_mdu, rtp_tbl.rtp_nme, lng_tbl.lng_lgn FROM zrt_tbl INNER JOIN rtp_tbl ON zrt_tbl.zrt_pid=rtp_tbl.rtp_mid INNER JOIN lng_tbl ON zrt_tbl.zrt_lid=lng_tbl.lng_mid WHERE zrt_tbl.zrt_mid=:zrt_mid";
			$resz = $dbcn->prepare($sqlz);
			$resz->execute([
							'zrt_mid'=>$val1
						]);

			// fetch the datas from the database into the row variable
			$rowz = $resz->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'zion-retreat', 'zion-retreat-pg');

		} // select zion retreat data selection as per the given id close

		// if only 1 row returned the id is valid
		if(isset($rowz) && is_array($rowz) && count($rowz) == 1) {

			// page visit into log
			$this->sbmli($val1, @$_SESSION['urid'], 'Preview zion retreat page delivered', 'zion-retreat', 'zion-retreat-pg');

// page body and container start tag start
$cont = <<<AAA
<div class="page-body">
	<div class="container-fluid">

AAA; // page body and container start tag close

// row class start tag start
$cont .= <<<AAA
		<div class="row">

AAA; // row class start tag close

// left col tag start tag start
$cont .= <<<AAA
			<div class="col-lg-4">

AAA; // left col tag start tag close

	// retreat name into variable
	$rttt = $this->zrnrt($rowz[0]);
	// retreat date into variable
	$rtdt = sprintf('
						%s %s %s - %s %s %s'
						,date("d", $rowz[0]['zrt_sdt'])
						,date("m", $rowz[0]['zrt_sdt']) == date("m", $rowz[0]['zrt_edt'])
							?
						''
							:
						date("M", $rowz[0]['zrt_sdt'])
						,date("Y", $rowz[0]['zrt_sdt']) == date("Y", $rowz[0]['zrt_edt'])
							?
						''
							:
						date("Y", $rowz[0]['zrt_sdt'])
						,date("d", $rowz[0]['zrt_edt'])
						,date("M", $rowz[0]['zrt_edt'])
						,date("Y", $rowz[0]['zrt_edt'])
					);

	// retreat parent name
	$rtnm = $rowz[0]['rtp_nme'];
	// adult cost
	$zrac = round($rowz[0]['zrt_act']);
	// child cost
	$zrcc = round($rowz[0]['zrt_cct']);
	// main language name
	$zrlg = $rowz[0]['lng_lgn'];
	// open status
	$zros = $rowz[0]['zrt_ost'] == 333
				?
			'<span class="badge badge-light-success">Open</span>'
				:
			'<span class="badge badge-light-danger">Closed</span>';
	// status
	$zrst = $rowz[0]['zrt_sts'] == 333
				?
			'<span class="badge badge-success">Active</span>'
				:
			'<span class="badge badge-warning">Inactive</span>';

// basic details block start
$cont .= <<<AAA
				<div class="card mb-2">
					<div class="card-header d-flex justify-content-center text-center">
						<h5 class="mb-0 f-w-600">$rttt</h5>
					</div>
					<div class="card-body">
						<div class="taskadd">
							<div class="row">
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Retreat :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600 txt-primary">$rtnm</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Date :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$rtdt</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Cost :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">
										₹ $zrac <span class="f-w-400 f-12">(Adult)</span>, ₹ $zrcc <span class="f-w-400 f-12">(Child)</span></h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Main Language :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrlg</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Open Status :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zros</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted">Status :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrst</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
							</div>
						</div>
					</div>
				</div>

AAA; // basic details block close

// left col tag close tag start
$cont .= <<<AAA
			</div>

AAA; // left col tag close tag close

// right col tag start tag start
$cont .= <<<AAA
			<div class="col-lg-8 default-according style-1 faq-accordion" id="pwblk">

AAA; // right col tag start tag close

	// admin users array call
	$adur = $this->aduar('zion-retreat');

	// zion retreat id
	$zrid = $rowz[0]['zrt_mid'];
	// retreat start date & time
	$zrsd = date("d-M-Y, h:i A, D", $rowz[0]['zrt_sdt']);
	// retreat end date & time
	$zred = date("d-M-Y, h:i A, D", $rowz[0]['zrt_edt']);
	// remarks
	$zrrm = $rowz[0]['zrt_rmk'];
	// retreat close date & time
	$zrcd = $rowz[0]['zrt_ost'] == 333
				?
			(
				$rowz[0]['zrt_cld'] > date('U')
					?
				date("d-M-Y, h:i A, D", $rowz[0]['zrt_cld'])
					:
				'<span class="txt-danger">Already closed</span>'
			)
				:
			'<span class="txt-warning">Not opened yet</span>';

	// admin added by
	$zrab = isset($adur[$rowz[0]['zrt_adu']])
				?
			$adur[$rowz[0]['zrt_adu']]
				:
			'N/A';
	// added by as block
	$zrab = ($_SESSION['urtp'] == 111 || ($_SESSION['urtp'] == 222 && isset($upar['ltmb'])))
				?
			sprintf('<a href="%spreview-member/%s/%s" class="badge badge-light text-dark f-14" target="_blank">%s</a>', $wpfx, $rowz[0]['zrt_adu'], md5("^#" . $rowz[0]['zrt_adu'] . "#^"), $zrab)
				:
			sprintf('<span class="badge badge-light text-dark f-14">%s</span>', $zrab);
	// admin last modified by
	$zrmb = isset($adur[$rowz[0]['zrt_mdu']])
				?
			$adur[$rowz[0]['zrt_mdu']]
				:
			'N/A';
	// last modified by as block
	$zrmb = ($_SESSION['urtp'] == 111 || ($_SESSION['urtp'] == 222 && isset($upar['ltmb'])))
				?
			sprintf('<a href="%spreview-member/%s/%s" class="badge badge-light text-dark f-14" target="_blank">%s</a>', $wpfx, $rowz[0]['zrt_mdu'], md5("^#" . $rowz[0]['zrt_mdu'] . "#^"), $zrmb)
				:
			sprintf('<span class="badge badge-light text-dark f-14">%s</span>', $zrmb);

	// admin added on
	$zrad = date("d-M-Y, h:i A, D", $rowz[0]['zrt_adt']);
	// admin last modified on
	$zrmd = date("d-M-Y, h:i A, D", $rowz[0]['zrt_mdt']);

// basic details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#bsdtb" aria-expanded="false">
								<i data-feather="arrow-right-circle"></i> Basic Details
							</button>
						</h5>
					</div>
					<div class="collapse" id="bsdtb" aria-labelledby="bsdtb" data-bs-parent="#pwblk">
						<div class="taskadd">
							<div class="row mt-3">
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Zion Retreat ID :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrid</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Starting At :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrsd</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Ending At :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zred</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Remarks :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrrm</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Closing At :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrcd</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Added On :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrad</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Last Modified On :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrmd</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Added By :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrab</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted">Last Modified By :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600">$zrmb</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
							</div>
						</div>
					</div>
				</div>

AAA; // basic details block close

// login details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#llgtb" aria-expanded="false" aria-controls="collapseicon2">
								<i data-feather="arrow-right-circle"></i> Zion Retreat Statistics
							</button>
						</h5>
					</div>
					<div class="collapse" id="llgtb" data-bs-parent="#pwblk">
						<div class="w-100 p-3 text-muted">
							<div class="f-14 mb-3">Visit <a href="{$wpfx}booking-statistics/$val1/$val2" target="_blank" class="txt-primary f-w-600">Booking Statistics Page</a> to view booking statistics</div>
							<div class="f-14">Visit <a href="{$wpfx}registration-statistics/$val1/$val2" target="_blank" class="txt-primary f-w-600">Registration Statistics Page</a> to view registration statistics</div>
						</div>
					</div>
				</div>

AAA; // login details block close

	// call allocated member list into variable
	$allt = $this->mgzal('', 'zion-retreat', 222);
	// allocated member list content length check
	$alml = strlen($allt) > 20
				?
			$allt
				:
			'<span class="txt-danger mt-2">No allocated members found</span>';

// allocated members details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#almtb" aria-expanded="false" aria-controls="collapseicon2">
								<i data-feather="arrow-right-circle"></i> Allocated Members
							</button>
						</h5>
					</div>
					<div class="collapse" id="almtb" data-bs-parent="#pwblk">
						<div class="w-100 p-3 p-t-0">
							$alml
						</div>
					</div>
				</div>

AAA; // allocated members details block close

// right col tag close tag start
$cont .= <<<AAA
			</div>

AAA; // right col tag close tag close

// row class close tag start
$cont .= <<<AAA
		</div>

AAA; // row class close tag close

// page body and container close tag start
$cont .= <<<AAA
	</div>
</div>

AAA; // page body and container close tag close
echo $cont;

		} // row count check close

	} // get value check close

}
// pwzrc - preview zion retreat additional css content
function pwzrc() {

	// icofc - iconfont css initialize call
	$this->icofc();
	// aoscs - aos animation css initialize call
	$this->aoscs();

}
// pwzrj - preview zion retreat additional js content
function pwzrj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();

}

}//class closed
?>