<?php
include("cls4.php");
Class Cls5 extends Cls4 {

/* **************** **************** **************** ****************
                            ADMIN FUNCTIONS
------- add admin functions -------
01) adurs - add admin user form submit
02) adurf - add admin user form html
03) adurc - add admin user additional css content
04) adurj - add admin user additional js content

------- list admin functions -------
01) ltusr - list admin users table content
02) ltuss - list admin users actions submit
03) lturc - list admin users additional css content
04) lturj - list admin users additional js content

------- edit admin functions -------
01) edurs - edit admin user form submit
02) edurf - edit admin user form html
03) edurc - edit admin user additional css content
04) edurj - edit admin user additional js content

------- preview admin functions -------
01) prwur - preview admin users html content
02) pwurc - preview admin users additional css content
03) pwurj - preview admin users additional js content

------- preview admin supporting functions -------
01) pwalb - preview admin users login log contents
02) pwazr - preview admin users allocated zion retreats content

------- admin password reset functions -------
01) cpurs - change password admin user form submit
02) cpurf - change password admin user form html
03) cpurc - change password admin user additional css content
04) cpurj - change password admin user additional js content

------- admin supporting functions -------
01) adupa - admin users permissions array
02) adcbm - admin users permissions checkbox making
03) adplt - admin users permissions list making
**************** **************** **************** **************** */

// ------- add admin functions -------
// adurs - add admin user form submit
function adurs() {
GLOBAL $dbcn, $wpfx;

	// if form is submitted and conditions satisfied
	if(isset($_POST['fssa'], $_POST['fssb'], $_POST['fssc']) && $_POST['fssc'] == md5("|=".($_POST['fssb']-333)."=|")) {

		// page visit into log
		$this->sbmli(NULL, @$_SESSION['urid'], 'Add admin form submitted', 'admin', 'admin-pg');

		// if form is accidently submitted
		if(isset($_POST['fssa'],$_SESSION['fmck']) && $_SESSION['fmck'] == $_POST['fssa']) {

		// if form is freshly submitted
		} else {

			// initialize alert message variable
			$alrt = '';

			// member zion id input format
			$mbid = $this->inpvl($_POST['mbid'],0,'',0);

			// member user name input format
			$usnm = $this->inpvl($_POST['usnm'],0,'',0);
			// member password input format
			$uspw = $this->inpvl($_POST['uspw'],0,'',0);

			// member type input format
			$mbtp = $this->inpvl($_POST['mbtp'],0,'',0);
			// member permission array input format
			$pmar = (isset($_POST['pmar']) && is_array($_POST['pmar']))
						?
					$_POST['pmar']
						:
					array();

			// member status input format
			$usst = (isset($_POST['usst']) && $_POST['usst'] == 333)
						?
					333
						:
					999;

			// check member id is valid one
			$mbri = $this->chkzi($mbid, 'admin');

			// member id is invalid one
			if($mbri <= 100000) {

				// page visit into log
				$this->sbmli($mbid, @$_SESSION['urid'], 'Add admin form submitted, invalid member id', 'admin', 'admin-pg');

				// alert message into variable
				$alrt = "<script>
							Swal.fire({
								icon: 'error',
								title: 'Invalid ID',
								text: 'Invalid Zion ID, try again',
								confirmButtonColor: '#cc2f26'
							});
						</script>";

			// member id is valid one
			} else {

				// check already existing member id or username in database
				try {

					// username and member id selection for duplicate check query
					$sqlc = "SELECT adm_mbi, adm_usn, adm_sts FROM adm_usr WHERE adm_mbi=:adm_mbi OR adm_usn=:adm_usn";
					$resc = $dbcn->prepare($sqlc);
					$resc->execute([
									'adm_mbi'=>$mbri
									,'adm_usn'=>$usnm
								]);

					// fetch the datas from the database into the row variable
					$rowc = $resc->fetchAll();

				} catch(Exception $e) {

					// error log into file
					$this->errli($mbri, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

				} // check already existing member id or username in database close

				// if data already exists, return error message
				if(isset($rowc) && is_array($rowc) && count($rowc) > 0) {

					// error message text variable initialize
					$emtx = '';

					// iterate through error array
					foreach($rowc as $rwky => $rwvl) {

						// error message text variable initialize
						$emtx .= sprintf('<div>%s</div><div>%s</div>'
											,$rwvl['adm_mbi'] == $mbri
												?
											'Member Zion Id already have login, try again'
												:
											''
											,$rwvl['adm_usn'] == $usnm
												?
											'Username already exists, try again'
												:
											''
										);

						// page visit into log
						$this->sbmli($mbri, @$_SESSION['urid'], 'Add admin form submitted, ' . $emtx, 'admin', 'admin-pg');

					} // error array iteration close

					// alert message into variable
					$alrt = "<script>
								Swal.fire({
									icon: 'error',
									title: 'Already Exists',
									html: '$emtx',
									confirmButtonColor: '#cc2f26'
								});
							</script>";

				// if data is fresh to add
				} else {

					// insert admin user data into database
					try {

						// admin user data insert query
						$sqlg = "INSERT INTO adm_usr(adm_usn, adm_psw, adm_mbi, adm_ltp, adm_prm, adm_sys, adm_sts, adm_adt, adm_mdt, adm_adu, adm_mdu, adm_ads, adm_mds) VALUES (:adm_usn, :adm_psw, :adm_mbi, :adm_ltp, :adm_prm, :adm_sys, :adm_sts, :adm_adt, :adm_mdt, :adm_adu, :adm_mdu, :adm_ads, :adm_mds)";
						$resg = $dbcn->prepare($sqlg);
						$resg->execute([
										'adm_usn'=>$usnm
										,'adm_psw'=>md5("*^" . $uspw . "^*")
										,'adm_mbi'=>$mbri
										,'adm_ltp'=>$mbtp
										,'adm_prm'=>serialize($pmar)
										,'adm_sys'=>999
										,'adm_sts'=>$usst
										,'adm_adt'=>date('U')
										,'adm_mdt'=>date('U')
										,'adm_adu'=>$_SESSION['urid']
										,'adm_mdu'=>$_SESSION['urid']
										,'adm_ads'=>$_SESSION['snid']
										,'adm_mds'=>$_SESSION['snid']
									]);

						// alert message into variable
						$alrt = sprintf("
											<script>
												Swal.fire({
													icon: 'success',
													title: 'Admin Added',
													html: '<div>Admin user data successfully added</div><table class=\'table mb-0\'><tbody><tr><td class=\'text-end f-14\'>Username:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr><tr><td class=\'text-end f-14\'>Password:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr><tr><td class=\'text-end f-14\'>Admin Type:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr></tbody></table>',
													confirmButtonColor: '#45afd2',
													confirmButtonText: 'View List',
													showCancelButton: true,
													allowOutsideClick: false,
													allowEscapeKey: false,
													cancelButtonText: 'Add Another'
												}).then((result) => {
													if(result.isConfirmed) {
														window.location.href = '%s/admins-list';
													} else {
														window.location.href = '%s/add-admin';
													}
												});
											</script>"
											,$usnm
											,$uspw
											,$mbtp == 111
												?
											'Admin'
												:
											'Moderator'
											,$wpfx
											,$wpfx
										);

						// last inserted admin id
						$lsid = $dbcn->lastInsertId();

						// actar - action types array
						$acar = $this->actar();
						// action text into variable
						$actx = str_replace('***', $usnm, $acar[1001]);

						// action log save function call
						$this->actli($lsid, 1001, $_SESSION['urid'], $actx, 'admin', 'admin-pg');

					} catch(Exception $e) {

						// error log into file
						$this->errli($mbri, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

					} // admin user data insert close

				} // data row count check close

			} // member id valid check close

			// set the variable for the accident form submit
			$_SESSION['fmck'] = $_POST['fssa'];

			// return alert message
			return $alrt;

		} // form accidently submitted check close

	} // form submitted check close

}
// adurf - add admin user form HTML
function adurf() {

	// page visit into log
	$this->sbmli(NULL, @$_SESSION['urid'], 'Add admin page visited', 'admin', 'admin-pg');

	// member zion id input value
	$mbid = isset($_POST['mbid'])
				?
			$_POST['mbid']
				:
			'';

	// user name input value
	$usnm = isset($_POST['usnm'])
				?
			$_POST['usnm']
				:
			'';

	// member type admin input value
	$mbt1 = (isset($_POST['mbtp']) && $_POST['mbtp'] == 111)
				?
			'checked'
				:
			'';
	// member type moderator input value
	$mbt2 = (isset($_POST['mbtp']) && $_POST['mbtp'] == 222)
				?
			'checked'
				:
			'';

	// admin status input value
	$usst = (isset($_POST['fssa']) && !isset($_POST['usst']))
				?
			''
				:
			'checked';

	// input hiddens for form
	$inhd = $this->inhdn();

// page content start tag start
$cont = <<<AAA
			<div class="page-body">

AAA; // page content start tag close

// form main block opening start
$cont .= <<<AAA
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card">

							<form method="post" id="adfm" class="mbff needs-validation custom-input" novalidate>

AAA; // form main block opening close

// form member details block start
$cont .= <<<AAA
								<div class="card-header pb-2" data-aos="fade-left">
									<h4 class="card-title">Member Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 fmbk col-md-4 position-relative">
												<label for="mbid" class="mb-1">Member Zion ID <span class="text-danger">*</span></label>
												<input type="number" class="form-control fmbi" id="mbid" name="mbid" aria-describedby="mbidhp" placeholder="Enter Zion ID" min="1" max="300000" step="1" value="$mbid" autocomplete="off" required data-pgnm="admin">
												<small id="mbidhp" class="form-text text-muted">Enter Zion member id of user</small>
												<div class="invalid-tooltip">Enter Zion ID of member</div>
											</div>

										</div>

									</div>
								</div>

AAA; // form member details block close

// form login details block start
$cont .= <<<AAA
								<div class="card-header pt-0 pb-2" data-aos="fade-left">
									<h4 class="card-title">Login Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 col-md-4 position-relative">
												<label for="usnm" class="mb-1">Username <span class="text-danger">*</span></label>
												<input type="text" class="form-control" id="usnm" name="usnm" aria-describedby="usnmhp" placeholder="Enter username" value="$usnm" minlength="3" pattern="^[0-9a-zA-Z]*$" autocomplete="off" required>
												<small id="usnmhp" class="form-text text-muted">Enter username for login, only a-z and 0-9 allowed, no space allowed</small>
												<div class="invalid-tooltip">Enter minimum 3 chars username, a-z & 0-9 only</div>
											</div>

											<div class="col-sm-6 col-md-4 position-relative">
												<label for="uspw" class="mb-1">Password <span class="text-danger">*</span></label>
												<input type="text" class="form-control pass--field" id="uspw" name="uspw" aria-describedby="uspwhp" placeholder="Enter password" minlength="4" autocomplete="off" required>
												<small id="uspwhp" class="form-text text-muted">Enter password for login, minimum 4 characters required</small>
												<div class="invalid-tooltip">Enter minimum 4 chars password</div>	
											</div>

										</div>

									</div>
								</div>

AAA; // form login details block close

	// adcbm - admin users permissions checkbox making
	$pmlt = $this->adcbm(array());
	// if member type is moderator, show permission block if submitted
	$pmbk = (isset($_POST['mbtp']) && $_POST['mbtp'] == 222)
				?
			''
				:
			'style="display:none;"';

// form permission details block start
$cont .= <<<AAA
								<div class="card-header pt-0 pb-2" data-aos="fade-left">
									<h4 class="card-title">Permission Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 col-md-4 position-relative">
												<label for="mbtp" class="mb-1 d-block">Member Type <span class="text-danger">*</span></label>
												<div class="form-check form-check-inline radio radio-primary">
													<input class="form-check-input mbtp" id="mbt1" type="radio" name="mbtp" value="111" required $mbt1>
													<label class="form-check-label mb-0" for="mbt1">Admin</label>
												</div>
												<div class="form-check form-check-inline radio radio-primary position-relative">
													<input class="form-check-input mbtp" id="mbt2" type="radio" name="mbtp" value="222" required $mbt2>
													<label class="form-check-label mb-0" for="mbt2">Moderator</label>
												</div>
												<small id="mbt2hp" class="form-text text-muted d-block"><strong>Admin</strong> have access to all functions, while <strong>Moderator</strong> is restricted in some of the functions.</small>
												<div class="invalid-tooltip">Select admin type</div>
											</div>

											<div class="col-sm-12 pmbk" $pmbk>
												$pmlt
											</div>

										</div>

									</div>
								</div>

AAA; // form permission details block close

// form status block start
$cont .= <<<AAA
								<div class="card-body pt-2 pb-0">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-12">
												<div class="checkbox checkbox-primary mb-0 mt-0">
													<input id="usst" name="usst" type="checkbox" value="333" $usst>
													<label class="form-check-label f-14" for="usst">Tick if admin/moderator is active</label>
												</div>
                                            </div>

										</div>

									</div>
								</div>

AAA; // form status block close

// form input hidden and button block start
$cont .= <<<AAA

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<input type="hidden" id="fssa" name="fssa" value="{$inhd[0]}">
											<input type="hidden" id="fssb" name="fssb" value="{$inhd[1]}">
											<input type="hidden" id="fssc" name="fssc" value="{$inhd[2]}">

											<div class="col-sm-12">
												<button type="submit" class="btn btn-primary w-auto">Save</button>
											</div>

										</div>

									</div>
								</div>

AAA; // form input hidden and button block close

// form main block closing start
$cont .= <<<AAA

							</form>

                        </div>

                    </div>
                </div>

AAA; // form main block closing close

// page content close tag start
$cont .= <<<AAA
			</div>

AAA; // page content close tag close
echo $cont;

}
// adurc - add admin user additional css content
function adurc() {

	// aoscs - aos animation css initialize call
	$this->aoscs();

// admin page css start
$cont = <<<AAA
	<style>
		.pass--field {
			-webkit-text-security: disc;
			text-security: disc;
		}
	</style>

AAA; // admin page css close
echo $cont;

}
// adurj - add admin user additional js content
function adurj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();
	// ftmbj - fetch member block by by zion id js initialize call
	$this->ftmbj();
	// fmvld - form validation js initialize call
	$this->fmvld();

// username to lowercase js function
$cont = <<<'AAA'
	<script>
		$("#usnm").change(function(){
			let uval = $("#usnm").val().toLowerCase();
			$("#usnm").val(uval);
		});
	</script>

AAA; // username to lowercase js function close

// permission block display start
$cont .= <<<'AAA'
	<script>
		$(".mbtp").on("change", function(){
			if($('.mbtp:checked').val() == 222) {
				$('.pmbk').show(150);
			} else {
				$('.pmbk').hide(150);
			}
		});
	</script>

AAA; // permission block display close

// permission all check function start
$cont .= <<<'AAA'
	<script>
		$(".saad").on("change", function(){ // add
			if($(this).is(':checked')) {
				$('.saac').prop('checked', true);
			} else {
				$('.saac').prop('checked', false);
			}
		});

		$(".salt").on("change", function(){ // list
			if($(this).is(':checked')) {
				$('.salc').prop('checked', true);
			} else {
				$('.salc').prop('checked', false);
			}
		});

		$(".saed").on("change", function(){ // edit
			if($(this).is(':checked')) {
				$('.saec').prop('checked', true);
			} else {
				$('.saec').prop('checked', false);
			}
		});
	</script>

AAA; // permission all check function close

// all check permission checkbox management js function
$cont .= <<<'AAA'
	<script>
		$(document).ready(function(){
			cbkMg();
		});

		$(".saac, .salc, .saec").change(function(){
			cbkMg();
		});

		function cbkMg() {
			if($(".saac").length == $(".saac:checked").length) {
				$(".saad").prop('checked', true);
			} else {
				$(".saad").prop('checked', false);
			}

			if($(".salc").length == $(".salc:checked").length) {
				$(".salt").prop('checked', true);
			} else {
				$(".salt").prop('checked', false);
			}

			if($(".saec").length == $(".saec:checked").length) {
				$(".saed").prop('checked', true);
			} else {
				$(".saed").prop('checked', false);
			}
		}
	</script>

AAA; // all check permission checkbox management js function close
echo $cont;

}


// ------- list admin functions -------
// ltusr - list admin users table content
function ltusr() {
GLOBAL $dbcn, $wpfx;

	// page visit into log
	$this->sbmli(NULL, @$_SESSION['urid'], 'Admin list page visited', 'admin', 'admin-pg');

	// admin active count initialize
	$aact = 0;
	// admin inactive count initialize
	$aict = 0;
	// admin count initialize
	$auct = 0;
	// moderator count initialize
	$muct = 0;

	// select main list data from database as per the inputs
	try {

		// login log selection query
		$sqla = sprintf("SELECT COUNT(*) as acnt, adm_ltp, adm_sts FROM adm_usr GROUP BY  adm_ltp, adm_sts");
		$resa = $dbcn->prepare($sqla);
		$resa->execute();

		// fetch the datas from the database into the row variable
		while($rowa = $resa->fetch()) {

			// if active admin
			if($rowa['adm_sts'] == 333) {

				// active admin count increment
				$aact += $rowa['acnt'];

			} // active admin check close

			// if blocked admin
			if($rowa['adm_sts'] == 999) {

				// blocked admin count increment
				$aict += $rowa['acnt'];

			} // blocked admin check close

			// if admin user
			if($rowa['adm_ltp'] == 111) {

				// admin user count increment
				$auct += $rowa['acnt'];

			} // admin user check close

			// if moderator user
			if($rowa['adm_ltp'] == 222) {

				// moderator user count increment
				$muct += $rowa['acnt'];

			} // moderator user check close

		} // main list while loop iteration close

	} catch(Exception $e) {

		// error log into file
		$this->errli(NULL, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

	} // main list selection close

	// input hiddens for form
	$inhd = $this->inhdn();

// page wrap start tag start
$cont = <<<AAA
<div class="page-body">

AAA; //page wrap start tag close

// statistics container start tag start
$cont .= <<<AAA
	<div class="container default-dashboard">
		<div class="owl-carousel sale-statistic stat--slider">

AAA; // statistics container start tag close

// total active admin count
$cont .= $this->stbmk('admin-active.png', 'Active', 'users', $aact, 'success', 'slide-right');
// total inactive admin count
$cont .= $this->stbmk('admin-blocked.png', 'Inactive', 'users', $aict, 'warning', 'slide-up');
// total admin count
$cont .= $this->stbmk('admin-admin-users.png', 'Admin', 'users', $auct, 'primary', 'slide-up');
// total moderator count
$cont .= $this->stbmk('admin-moderator-users.png', 'Moderator', 'users', $muct, 'danger', 'slide-left');

// statistics container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // statistics container close tag close

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-12">
				<div class="card">

AAA; // card start tag close

	// checkbox list variables initialize
	$cblt = '';
	// checkbox header variables initialize
	$cbhd = '';
	// checkbox footer variables initialize
	$cbft = '';
	// checkbox count variables initialize
	$itct = 0;

	// checkbox array
	$cbar = array(
					array('chkd'=>333, 'coln'=>1, 'valt'=>'Name')
					,array('chkd'=>333, 'coln'=>2, 'valt'=>'Zion ID')
					,array('chkd'=>333, 'coln'=>3, 'valt'=>'Type')
					,array('chkd'=>333, 'coln'=>4, 'valt'=>'Added On')
					,array('chkd'=>333, 'coln'=>5, 'valt'=>'Status')
				);

	// sl no thead into variable
	$cbhd .= '<th data-ptp="0" data-psh="1">S.N</th>';
	// sl no tfoot into variable
	$cbft .= '<th>S.N</th>';

	// iterate through checkbox array
	foreach($cbar as $cbky => $cbvl) {

		// checkbox into variable
		$cblt .= sprintf('
							<li>
								<div class="checkbox checkbox-colvis checkbox-primary mb-0 mt-0 ps-3 pe-2">
									<input class="d-none toggle-vis" id="clvc%s" type="checkbox" data-column="%s" %s>
									<label class="form-check-label" for="clvc%s">%s</label>
								</div>
							</li>'
							,$itct
							,$cbvl['coln']
							,$cbvl['chkd'] == 333
								?
							'checked'
								:
							''
							,$itct
							,$cbvl['valt']
						);

		// increment count variable
		$itct++;

		// thead into variable
		$cbhd .= sprintf('
							<th data-ptp="%s" data-psh="%s">%s</th>'
							,$itct
							,$cbvl['chkd'] == 333
								?
							1
								:
							0
							,$cbvl['valt']
						);

		// tfoot into variable
		$cbft .= sprintf('
							<th>%s</th>'
							,$cbvl['valt']
						);

	} // checkbox array iteration close

	// actions thead into variable variable
	$cbhd .= '<th data-ptp="' . $itct . '" data-psh="1" class="notexport dtend text-center">Actions</th>';
	// actions tfoot into variable
	$cbft .= '<th class="text-center">Actions</th>';

// card header tag start
$cont .= <<<AAA
					<div class="card-header">
						<div class="mt-2">
							<div class="btnbk d-inline-block"></div>
							<div class="d-inline-block">
								<div class="dropdown colVs">
									<button class="btn btn-secondary btn-colvis btn-datatable-main dropdown-toggle colvis-dropdown" type="button" id="toggleCol" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
										Column Visibility
									</button>
									<ul class="dropdown-menu colvDp p-3" aria-labelledby="toggleCol">
										$cblt
									</ul>
								</div>
							</div>
							<div class="float-end">
								<a href="{$wpfx}add-admin" class="btn btn-secondary btn-sm f-w-600">Add Admin</a>
							</div>
						</div>
					</div>

AAA; // card header tag close

	// date for file name
	$fldt = date("d-M-Y h_iA");
	// file download name
	$fldn = 'Admin list on';

// card body tag start
$cont .= <<<AAA
					<div class="card-body">
						<div class="">
							<table class="table table-bordered w-100" id="dttbl" data-tbttl="$fldn $fldt">
								<thead class="thead-light">
									<tr class="phd-mn">
										$cbhd
									</tr>
								</thead>
								<tbody>
								</tbody>
								<tfoot>
									<tr>
										$cbft
									</tr>
								</tfoot>
							</table>
						</div>
					</div>

AAA; // card body tag close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

// page wrap close tag start
$cont .= <<<AAA
</div>

AAA; // page wrap close tag close
echo $cont;

}
// ltuss - list admin users actions submit
function ltuss() {
}
// lturc - list admin users additional css content
function lturc() {

	// aoscs - aos animation css initialize call
	$this->aoscs();
	// owlsc - owl caraousel for statistics css initialize call
	$this->owlsc();
	// dtldc - datatable loader animation css initialize call
	$this->dtldc();
	// ohmbc - member block display on hover css initialize call
	$this->ohmbc();

}
// lturj - list admin users additional js content
function lturj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();
	// owlsj - owl animation for statistics js initialize call
	$this->owlsj();
	// dtldj - datatable loader animation js initialize call
	$this->dtldj();
	// ohmbj - member block display on hover js initialize call
	$this->ohmbj('admin');

// admin select from database ajax content making start, script tag close is done in dtbcl()
$cont = <<<'AAA'
			<script>
				var ccnt = dataTable.rows().count();

				var fmct = new FormData();
				fmct.append('idtf', '2412');
				fmct.append('ccnt', ccnt);
				fchDt(fmct);

AAA; // admin select from database ajax content making close
echo $cont;

	// dtbcl - datatable content loading js initialize call
	$this->dtbcl();

}


// ------- edit admin functions -------
// edurs - edit admin user form submit
function edurs() {
GLOBAL $dbcn, $wpfx;

	// if form is submitted and conditions satisfied
	if(isset($_POST['fssa'], $_POST['fssb'], $_POST['fssc']) && $_POST['fssc'] == md5("|=".($_POST['fssb']-333)."=|")) {

		// page visit into log
		$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Edit admin form submitted', 'admin', 'admin-pg');

		// if form is accidently submitted
		if(isset($_POST['fssa'],$_SESSION['fmck']) && $_SESSION['fmck'] == $_POST['fssa']) {

		// if form is freshly submitted
		} else {

			// initialize alert message variable
			$alrt = '';

			// member zion id input format
			$mbid = $this->inpvl($_POST['mbid'],0,'',0);

			// member user name input format
			$usnm = $this->inpvl($_POST['usnm'],0,'',0);

			// member type input format
			$mbtp = $this->inpvl($_POST['mbtp'],0,'',0);
			// member permission array input format
			$pmar = (isset($_POST['pmar']) && is_array($_POST['pmar']))
						?
					$_POST['pmar']
						:
					array();

			// member status input format
			$usst = (isset($_POST['usst']) && $_POST['usst'] == 333)
						?
					333
						:
					999;

			// check member id is valid one
			$mbri = $this->chkzi($mbid, 'admin');

			// member id is invalid one
			if($mbri <= 100000) {

				// page visit into log
				$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Edit admin form submitted, invalid member id - ' . $mbid, 'admin', 'admin-pg');

				// alert message into variable
				$alrt = "<script>
							Swal.fire({
								icon: 'error',
								title: 'Invalid ID',
								text: 'Invalid Zion ID, try again',
								confirmButtonColor: '#cc2f26'
							});
						</script>";

			// member id is valid one
			} else {

				// check already existing member id or username in database
				try {

					// username and member id selection for duplicate check query
					$sqlc = "SELECT adm_mbi, adm_usn, adm_sts FROM adm_usr WHERE (adm_mbi=:adm_mbi OR adm_usn=:adm_usn) AND adm_mid!=:adm_mid";
					$resc = $dbcn->prepare($sqlc);
					$resc->execute([
									'adm_mbi'=>$mbri
									,'adm_usn'=>$usnm
									,'adm_mid'=>$_GET['val1']
								]);

					// fetch the datas from the database into the row variable
					$rowc = $resc->fetchAll();

				} catch(Exception $e) {

					// error log into file
					$this->errli($_GET['val1'], @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

				} // check already existing member id or username in database close

				// if data already exists, return error message
				if(isset($rowc) && is_array($rowc) && count($rowc) > 0) {

					// error message text variable initialize
					$emtx = '';

					// iterate through error array
					foreach($rowc as $rwky => $rwvl) {

						// error message text variable initialize
						$emtx .= sprintf('<div>%s</div><div>%s</div>'
											,$rwvl['adm_mbi'] == $mbri
												?
											'Member Zion Id already have login, try again'
												:
											''
											,$rwvl['adm_usn'] == $usnm
												?
											'Username already exists, try again'
												:
											''
										);

						// page visit into log
						$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Edit admin form submitted, ' . $emtx . ' - ' . $mbri, 'admin', 'admin-pg');

					} // error array iteration close

					// alert message into variable
					$alrt = "<script>
								Swal.fire({
									icon: 'error',
									title: 'Already Exists',
									html: '$emtx',
									confirmButtonColor: '#cc2f26'
								});
							</script>";

				// if data is fresh to add
				} else {

					// update admin user data in database
					try {

						// admin user data update query
						$sqlg = "UPDATE adm_usr SET adm_usn=:adm_usn, adm_mbi=:adm_mbi, adm_ltp=:adm_ltp, adm_prm=:adm_prm, adm_sys=:adm_sys, adm_sts=:adm_sts, adm_mdt=:adm_mdt, adm_mdu=:adm_mdu, adm_mds=:adm_mds WHERE adm_mid=:adm_mid";
						$resg = $dbcn->prepare($sqlg);
						$resg->execute([
										'adm_usn'=>$usnm
										,'adm_mbi'=>$mbri
										,'adm_ltp'=>$mbtp
										,'adm_prm'=>serialize($pmar)
										,'adm_sys'=>999
										,'adm_sts'=>$usst
										,'adm_mdt'=>date('U')
										,'adm_mdu'=>$_SESSION['urid']
										,'adm_mds'=>$_SESSION['snid']
										,'adm_mid'=>$_GET['val1']
									]);

						// alert message into variable
						$alrt = sprintf("
											<script>
												Swal.fire({
													icon: 'success',
													title: 'Admin Edited',
													html: '<div>Admin user data successfully edited</div><table class=\'table mb-0\'><tbody><tr><td class=\'text-end f-14\'>Username:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr><tr><td class=\'text-end f-14\'>Admin Type:</td><td><h5 class=\'mb-0 text-start\'>%s</h5></td></tr></tbody></table>',
													confirmButtonColor: '#45afd2',
													confirmButtonText: 'View List',
													showCancelButton: true,
													allowOutsideClick: false,
													allowEscapeKey: false,
													cancelButtonText: 'Add Another'
												}).then((result) => {
													if(result.isConfirmed) {
														window.location.href = '%s/admins-list';
													} else {
														window.location.href = '%s/add-admin';
													}
												});
											</script>"
											,$usnm
											,$mbtp == 111
												?
											'Admin'
												:
											'Moderator'
											,$wpfx
											,$wpfx
										);

						// actar - action types array
						$acar = $this->actar();
						// action text into variable
						$actx = str_replace('***', $usnm, $acar[1002]);

						// action log save function call
						$this->actli($_GET['val1'], 1002, $_SESSION['urid'], $actx, 'admin', 'admin-pg');

					} catch(Exception $e) {

						// error log into file
						$this->errli($_GET['val1'], @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

					} // admin user data update close

				} // data row count check close

			} // member id valid check close

			// set the variable for the accident form submit
			$_SESSION['fmck'] = $_POST['fssa'];

			// return alert message
			return $alrt;

		} // form accidently submitted check close

	} // form submitted check close

}
// edurf - edit admin user form HTML
function edurf() {
GLOBAL $dbcn, $wpfx;

	// check get value and hash are matching
	if(isset($_GET['val1'], $_GET['val2']) && $_GET['val2'] == md5("^#" . $_GET['val1'] . "#^")) {

		// page visit into log
		$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Edit admin form requested', 'admin', 'admin-pg');

		// select admin data as per given id from database
		try {

			// admin data selection query
			$sqla = sprintf("
								SELECT adm_usr.adm_mid, adm_usr.adm_usn, adm_usr.adm_mbi, adm_usr.adm_ltp, adm_usr.adm_prm, adm_usr.adm_sts, mbr_zid.mzi_zid FROM adm_usr INNER JOIN mbr_bsc ON adm_usr.adm_mbi=mbr_bsc.mbr_mid INNER JOIN mbr_zid ON mbr_bsc.mbr_mid=mbr_zid.mzi_mbi WHERE adm_usr.adm_mid=:adm_mid"
							);
			$resa = $dbcn->prepare($sqla);
			$resa->execute([
							'adm_mid'=>$_GET['val1']
						]);

			// fetch the datas from the database into the row variable
			$rowa = $resa->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($_GET['val1'], @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

		} // select admin data selection as per the given id close

		// if only 1 row returned the id is valid
		if(isset($rowa) && is_array($rowa) && count($rowa) == 1) {

			// page visit into log
			$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Edit admin form delivered', 'admin', 'admin-pg');

			// member zion id input value
			$mbid = isset($_POST['mbid'])
						?
					$_POST['mbid']
						:
					$rowa[0]['mzi_zid'];

			// user name input value
			$usnm = isset($_POST['usnm'])
						?
					$_POST['usnm']
						:
					$rowa[0]['adm_usn'];

			// admin permission array input value
			$upra = strlen($rowa[0]['adm_prm']) > 10
						?
					unserialize($rowa[0]['adm_prm'])
						:
					array();

			// member type admin input value
			$mbt1 = (isset($_POST['mbtp']) && $_POST['mbtp'] == 111)
						?
					'checked'
						:
					(
						$rowa[0]['adm_ltp'] == 111
							?
						'checked'
							:
						''
					);
			// member type moderator input value
			$mbt2 = (isset($_POST['mbtp']) && $_POST['mbtp'] == 222)
						?
					'checked'
						:
					(
						$rowa[0]['adm_ltp'] == 222
							?
						'checked'
							:
						''
					);

			// admin status input value
			$usst = isset($_POST['fssa'])
						?
					(
						(isset($_POST['usst']) && $_POST['usst'] == 333)
							?
						'checked'
							:
						''
					)
						:
					(
						$rowa[0]['adm_sts'] == 333
							?
						'checked'
							:
						''
					);

			// input hiddens for form
			$inhd = $this->inhdn();

// page content start tag start
$cont = <<<AAA
			<div class="page-body">

AAA; // page content start tag close

// form main block opening start
$cont .= <<<AAA
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card">

							<form method="post" id="edfm" class="mbff needs-validation custom-input" novalidate>

AAA; // form main block opening close

// form member details block start
$cont .= <<<AAA
								<div class="card-header pb-2" data-aos="fade-left">
									<h4 class="card-title">Member Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 fmbk col-md-4 position-relative">
												<label for="mbid" class="mb-1">Member Zion ID <span class="text-danger">*</span></label>
												<input type="number" class="form-control fmbi" id="mbid" name="mbid" aria-describedby="mbidhp" placeholder="Enter Zion ID" min="1" max="300000" step="1" value="$mbid" autocomplete="off" required data-pgnm="admin">
												<small id="mbidhp" class="form-text text-muted">Enter Zion member id of user</small>
												<div class="invalid-tooltip">Enter Zion ID of member</div>
											</div>

										</div>

									</div>
								</div>

AAA; // form member details block close

// form login details block start
$cont .= <<<AAA
								<div class="card-header pt-0 pb-2" data-aos="fade-left">
									<h4 class="card-title">Login Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 col-md-4 position-relative">
												<label for="usnm" class="mb-1">Username <span class="text-danger">*</span></label>
												<input type="text" class="form-control" id="usnm" name="usnm" aria-describedby="usnmhp" placeholder="Enter username" value="$usnm" minlength="3" pattern="^[0-9a-zA-Z]*$" autocomplete="off" required>
												<small id="usnmhp" class="form-text text-muted">Enter username for login, only a-z and 0-9 allowed, no space allowed</small>
												<div class="invalid-tooltip">Enter minimum 3 chars username, a-z & 0-9 only</div>
											</div>

											<div class="col-sm-6 col-md-4">
												<label for="usnm" class="mb-1">Password</label>
												<div class="alert alert-light-warning light fade show text-dark border-left-wrapper" role="alert">
													<i data-feather="alert-circle"></i>
													<p>To change admin password, you can visit the following link. <a href="{$wpfx}admin-password/{$_GET['val1']}/{$_GET['val2']}" class="txt-warning f-w-600" target="_blank">Change Admin Password</a></p>
												</div>
											</div>

										</div>

									</div>
								</div>

AAA; // form login details block close

	// adcbm - admin users permissions checkbox making
	$pmlt = $this->adcbm($upra);
	// if member type is moderator, show permission block if submitted
	$pmbk = (isset($_POST['mbtp']) && $_POST['mbtp'] == 222)
				?
			''
				:
			'style="display:none;"';

// form permission details block start
$cont .= <<<AAA
								<div class="card-header pt-0 pb-2" data-aos="fade-left">
									<h4 class="card-title">Permission Details</h4>
								</div>

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-6 col-md-4 position-relative">
												<label for="mbtp" class="mb-1 d-block">Member Type <span class="text-danger">*</span></label>
												<div class="form-check form-check-inline radio radio-primary">
													<input class="form-check-input mbtp" id="mbt1" type="radio" name="mbtp" value="111" required $mbt1>
													<label class="form-check-label mb-0" for="mbt1">Admin</label>
												</div>
												<div class="form-check form-check-inline radio radio-primary">
													<input class="form-check-input mbtp" id="mbt2" type="radio" name="mbtp" value="222" required $mbt2>
													<label class="form-check-label mb-0" for="mbt2">Moderator</label>
												</div>
												<small id="mbt2hp" class="form-text text-muted d-block"><strong>Admin</strong> have access to all functions, while <strong>Moderator</strong> is restricted in some of the functions.</small>
												<div class="invalid-tooltip">Select admin type</div>
											</div>

											<div class="col-sm-12 pmbk" $pmbk>
												$pmlt
											</div>

										</div>

									</div>
								</div>

AAA; // form permission details block close

// form status block start
$cont .= <<<AAA
								<div class="card-body pt-2 pb-0">
									<div class="general-label">

										<div class="row">

											<div class="col-sm-12">
												<div class="checkbox checkbox-primary mb-0 mt-0">
													<input id="usst" name="usst" type="checkbox" value="333" $usst>
													<label class="form-check-label f-14" for="usst">Tick if admin/moderator is active</label>
												</div>
                                            </div>

										</div>

									</div>
								</div>

AAA; // form status block close

// form input hidden and button block start
$cont .= <<<AAA

								<div class="card-body">
									<div class="general-label">

										<div class="row">

											<input type="hidden" id="fssa" name="fssa" value="{$inhd[0]}">
											<input type="hidden" id="fssb" name="fssb" value="{$inhd[1]}">
											<input type="hidden" id="fssc" name="fssc" value="{$inhd[2]}">

											<div class="col-sm-12">
												<button type="submit" class="btn btn-primary w-auto">Save</button>
											</div>

										</div>

									</div>
								</div>

AAA; // form input hidden and button block close

// form main block closing start
$cont .= <<<AAA

							</form>

                        </div>

                    </div>
                </div>

AAA; // form main block closing close

// page content close tag start
$cont .= <<<AAA
			</div>

AAA; // page content close tag close
echo $cont;

		} // row count check close

	} // get value check close

}
// edurc - edit admin user additional css content
function edurc() {

	// aoscs - aos animation css initialize call
	$this->aoscs();

}
// edurj - edit admin user additional js content
function edurj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();
	// ftmbj - fetch member block by by zion id js initialize call
	$this->ftmbj();
	// fmvld - form validation js initialize call
	$this->fmvld();

// username to lowercase js function
$cont = <<<'AAA'
	<script>
		$("#usnm").change(function(){
			let uval = $("#usnm").val().toLowerCase();
			$("#usnm").val(uval);
		});
	</script>

AAA; // username to lowercase js function close

// permission block display start
$cont .= <<<'AAA'
	<script>
		$(".mbtp").on("change", function(){
			pmCbk();
		});
		$(document).ready(function(){
			pmCbk();
		});
		function pmCbk() {
			if($('.mbtp:checked').val() == 222) {
				$('.pmbk').show(150);
			} else {
				$('.pmbk').hide(150);
			}
		}
	</script>

AAA; // permission block display close

// permission all check function start
$cont .= <<<'AAA'
	<script>
		$(".saad").on("change", function(){ // add
			if($(this).is(':checked')) {
				$('.saac').prop('checked', true);
			} else {
				$('.saac').prop('checked', false);
			}
		});

		$(".salt").on("change", function(){ // list
			if($(this).is(':checked')) {
				$('.salc').prop('checked', true);
			} else {
				$('.salc').prop('checked', false);
			}
		});

		$(".saed").on("change", function(){ // edit
			if($(this).is(':checked')) {
				$('.saec').prop('checked', true);
			} else {
				$('.saec').prop('checked', false);
			}
		});
	</script>

AAA; // permission all check function close

// all check permission checkbox management js function
$cont .= <<<'AAA'
	<script>
		$(document).ready(function(){
			cbkMg();
		});

		$(".saac, .salc, .saec").change(function(){
			cbkMg();
		});

		function cbkMg() {
			if($(".saac").length == $(".saac:checked").length) {
				$(".saad").prop('checked', true);
			} else {
				$(".saad").prop('checked', false);
			}

			if($(".salc").length == $(".salc:checked").length) {
				$(".salt").prop('checked', true);
			} else {
				$(".salt").prop('checked', false);
			}

			if($(".saec").length == $(".saec:checked").length) {
				$(".saed").prop('checked', true);
			} else {
				$(".saed").prop('checked', false);
			}
		}
	</script>

AAA; // all check permission checkbox management js function close
echo $cont;

}


// ------- preview admin functions -------
// prwur - preview admin users HTML content
function prwur() {
GLOBAL $dbcn, $wpfx, $upar;

	// check get value and hash are matching
	if(isset($_GET['val1'], $_GET['val2']) && $_GET['val2'] == md5("^#" . $_GET['val1'] . "#^")) {

		// val1 into variable
		$val1 = $_GET['val1'];

		// page visit into log
		$this->sbmli($val1, @$_SESSION['urid'], 'Preview admin page requested', 'admin', 'admin-pg');

		// select admin data as per given id from database
		try {

			// admin data selection query
			$sqla = sprintf("
								SELECT adm_usr.adm_mid, adm_usr.adm_usn, adm_usr.adm_mbi, adm_usr.adm_ltp, adm_usr.adm_prm, adm_usr.adm_sts, adm_usr.adm_adt, adm_usr.adm_mdt, adm_usr.adm_adu, adm_usr.adm_mdu, mbr_zid.mzi_zid, mbr_bsc.mbr_knn, loc_fsp.fsp_nme, loc_zon.zon_nme FROM adm_usr INNER JOIN mbr_bsc ON adm_usr.adm_mbi=mbr_bsc.mbr_mid INNER JOIN mbr_zid ON mbr_bsc.mbr_mid=mbr_zid.mzi_mbi INNER JOIN loc_fsp ON mbr_bsc.mbr_fid=loc_fsp.fsp_mid INNER JOIN loc_ara ON loc_fsp.fsp_aid=loc_ara.ara_lid INNER JOIN loc_zon ON loc_ara.ara_zid=loc_zon.zon_lid WHERE adm_usr.adm_mid=:adm_mid"
							);
			$resa = $dbcn->prepare($sqla);
			$resa->execute([
							'adm_mid'=>$val1
						]);

			// fetch the datas from the database into the row variable
			$rowa = $resa->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($val1, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

		} // select admin data selection as per the given id close

		// if only 1 row returned the id is valid
		if(isset($rowa) && is_array($rowa) && count($rowa) == 1) {

			// page visit into log
			$this->sbmli($val1, @$_SESSION['urid'], 'Preview admin page delivered', 'admin', 'admin-pg');
			// login log content into variable
			$llar = $this->pwalb();

// page body and container start tag start
$cont = <<<AAA
<div class="page-body">
	<div class="container-fluid">

AAA; // page body and container start tag close

// row class start tag start
$cont .= <<<AAA
		<div class="row">

AAA; // row class start tag close

// left col tag start tag start
$cont .= <<<AAA
			<div class="col-lg-4">

AAA; // left col tag start tag close

	// member id into variable
	$mbid = $rowa[0]['adm_mbi'];
	// member hash into variable
	$mbhs = md5("^#" . $mbid . "#^");

	// admin member name into variable
	$mbnm = $rowa[0]['mbr_knn'];
	// admin member zion ID into variable
	$mbzi = $rowa[0]['mzi_zid'];
	// admin member fellowship name into variable
	$mbfp = $rowa[0]['fsp_nme'];
	// admin member type into variable
	$mbat = $rowa[0]['adm_ltp'] == 111
				?
			'Admin'
				:
			'Moderator';
	// admin member status into variable
	$mbst = $rowa[0]['adm_sts'] == 333
				?
			'<span class="badge badge-success">Active</span>'
				:
			'<span class="badge badge-warning">Inactive</span>';
	// login log last attempt time into variable
	$llad = isset($llar['lldt'])
				?
			$llar['lldt']
				:
			'N/A';

// basic details block start
$cont .= <<<AAA
				<div class="card mb-2">
					<div class="card-header d-flex justify-content-start">
						<a href="{$wpfx}preview-member/$mbid/$mbhs" target="_blank"><h4 class="mb-0 f-w-600" data-aos="flip-down">$mbnm</h4></a>
					</div>
					<div class="card-body">
						<div class="taskadd">
							<div class="row">
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted" data-aos="slide-right">Zion ID :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600 txt-primary" data-aos="slide-left">$mbzi</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted" data-aos="slide-right">Fellowship :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$mbfp</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted" data-aos="slide-right">Admin Type :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$mbat</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted" data-aos="slide-right">Status :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$mbst</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 text-muted" data-aos="slide-right">Last Login :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$llad</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
							</div>
						</div>
					</div>
				</div>

AAA; // basic details block close

// left col tag close tag start
$cont .= <<<AAA
			</div>

AAA; // left col tag close tag close

// right col tag start tag start
$cont .= <<<AAA
			<div class="col-lg-8 default-according style-1 faq-accordion" id="pwblk">

AAA; // right col tag start tag close

	// admin users array call
	$adur = $this->aduar('admin');

	// admin id
	$adid = $rowa[0]['adm_mid'];
	// admin username
	$adun = $rowa[0]['adm_usn'];
	// admin zones
	$adzn = $rowa[0]['zon_nme'];

	// admin added by
	$adab = isset($adur[$rowa[0]['adm_adu']])
				?
			$adur[$rowa[0]['adm_adu']]
				:
			'N/A';
	// added by as block
	$adab = ($_SESSION['urtp'] == 111 || ($_SESSION['urtp'] == 222 && isset($upar['ltmb'])))
				?
			sprintf('<a href="%spreview-member/%s/%s" class="badge badge-light text-dark f-14" target="_blank">%s</a>', $wpfx, $rowa[0]['adm_adu'], md5("^#" . $rowa[0]['adm_adu'] . "#^"), $adab)
				:
			sprintf('<span class="badge badge-light text-dark f-14">%s</span>', $adab);
	// admin last modified by
	$admb = isset($adur[$rowa[0]['adm_mdu']])
				?
			$adur[$rowa[0]['adm_mdu']]
				:
			'N/A';
	// last modified by as block
	$admb = ($_SESSION['urtp'] == 111 || ($_SESSION['urtp'] == 222 && isset($upar['ltmb'])))
				?
			sprintf('<a href="%spreview-member/%s/%s" class="badge badge-light text-dark f-14" target="_blank">%s</a>', $wpfx, $rowa[0]['adm_mdu'], md5("^#" . $rowa[0]['adm_mdu'] . "#^"), $admb)
				:
			sprintf('<span class="badge badge-light text-dark f-14">%s</span>', $admb);

	// admin added on
	$adad = date("d-M-Y, h:i A, D", $rowa[0]['adm_adt']);
	// admin last modified on
	$admd = date("d-M-Y, h:i A, D", $rowa[0]['adm_mdt']);

// basic details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#bsdtb" aria-expanded="false" data-aos="flip-up">
								<i data-feather="arrow-right-circle"></i> Basic Details
							</button>
						</h5>
					</div>
					<div class="collapse" id="bsdtb" aria-labelledby="bsdtb" data-bs-parent="#pwblk">
						<div class="taskadd">
							<div class="row mt-3">
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Admin ID :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$adid</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Username :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600 txt-primary" data-aos="slide-left">$adun</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Zone :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$adzn</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Added On :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$adad</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Last Modified On :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$admd</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Added By :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$adab</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
								<div class="col-sm-4 text-sm-end">
									<p class="project_name_0 mb-0 text-muted" data-aos="slide-right">Last Modified By :</p>
								</div>
								<div class="col-sm-8 text-start">
									<h6 class="task_title_0 f-w-600" data-aos="slide-left">$admb</h6>
								</div>
								<div class="col-sm-12">
									<hr/>
								</div>
							</div>
						</div>
					</div>
				</div>

AAA; // basic details block close

	// login log table into variable
	$llct = isset($llar['llct'])
				?
			$llar['llct']
				:
			'';

// login details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#llgtb" aria-expanded="false" aria-controls="collapseicon2" data-aos="flip-up">
								<i data-feather="arrow-right-circle"></i> Last 10 Logins
							</button>
						</h5>
					</div>
					<div class="collapse" id="llgtb" data-bs-parent="#pwblk">
						<div class="w-100">
							$llct
						</div>
					</div>
				</div>

AAA; // login details block close

	// admin permissions function call
	$adpr = $this->adplt($rowa[0]['adm_prm'], $rowa[0]['adm_ltp']);

// permission details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#prmbk" aria-expanded="false" aria-controls="collapseicon2" data-aos="flip-up">
								<i data-feather="arrow-right-circle"></i> Permissions List
							</button>
						</h5>
					</div>
					<div class="collapse" id="prmbk" data-bs-parent="#pwblk">
						$adpr
					</div>
				</div>

AAA; // permission details block close

	// allocated zion retreats content function call
	$azra = $this->pwazr();
	// incomplete zion retreats into variable
	$iczr = (isset($azra['aczr']) && strlen($azra['aczr']) > 50)
				?
			$azra['aczr']
				:
			'<h6 class="txt-danger ms-3">No incompete zion retreats found</h6>';
	// completed zion retreats into variable
	$cpzr = (isset($azra['hszr']) && strlen($azra['hszr']) > 50)
				?
			$azra['hszr']
				:
			'<h6 class="txt-danger ms-3">No competed zion retreats found</h6>';
	// completed zion retreats into variable
	$azct = (isset($azra['azct']) && $azra['azct'] > 0)
				?
			'<h6 class="f-w-500 text-muted mb-3 mt-0 ms-4">Total Zion Retreats Completed: <span class="px-2 f-w-500 font-primary">' . $azra['azct'] . '</span></h6>'
				:
			'';

// assigned retreats details block start
$cont .= <<<AAA
				<div class="card">
					<div class="card-header">
						<h5 class="mb-0">
							<button class="btn btn-link collapsed ps-0" data-bs-toggle="collapse" data-bs-target="#rzrtbk" aria-expanded="false" aria-controls="collapseicon2" data-aos="flip-up">
								<i data-feather="arrow-right-circle"></i> Allocated Zion Retreats
							</button>
						</h5>
					</div>
					<div class="collapse" id="rzrtbk" data-bs-parent="#pwblk">
						<div class="p-3 ps-4">
							<h5 class="f-w-600 mt-1 mb-3">Incomplete Zion Retreats</h5>
							$iczr
							<h5 class="f-w-600 mt-3 mb-3">Completed Zion Retreats (Last 12)</h5>
							$azct
							$cpzr
						</div>
					</div>
				</div>

AAA; // assigned retreats details block close

// right col tag close tag start
$cont .= <<<AAA
			</div>

AAA; // right col tag close tag close

// row class close tag start
$cont .= <<<AAA
		</div>

AAA; // row class close tag close

// page body and container close tag start
$cont .= <<<AAA
	</div>
</div>

AAA; // page body and container close tag close
echo $cont;

		} // row count check close

	} // get value check close

}
// pwurc - preview admin users additional css content
function pwurc() {

	// icofc - iconfont css initialize call
	$this->icofc();
	// dtscs - datatable simple css initialize call
	$this->dtscs();
	// aoscs - aos animation css initialize call
	$this->aoscs();

}
// pwurj - preview admin users additional js content
function pwurj() {

	// dtsjs - datatable simple js initialize call
	$this->dtsjs();
	// aosjs - aos animation js initialize call
	$this->aosjs();

// accordion table resposive re-initialize start
$cont = <<<'AAA'
	<script>
		$('#pwblk').on('shown.bs.collapse', function () {
			$('.dttsm').DataTable().columns.adjust().responsive.recalc();
		});
	</script>

AAA; // accordion table resposive re-initialize close
echo $cont;

}


// ------- preview admin supporting functions -------
// pwalb - preview admin users login log contents
function pwalb() {
GLOBAL $dbcn;

	// initialize return array
	$rtar = array('lldt' => '', 'llct' => '');

	// login log count variable initialize
	$llct = 0;
	// login attempts list variable initialize
	$lalt = '';
	// last login attempt date variable initialize
	$llad = 'N/A';

	// select admin login attempt data from database
	try {

		// login log selection query
		$sqll = "SELECT lgn_log.llg_sts, lgn_log.llg_dto, lgn_log.llg_uid, ssn_dtb.ssn_ipa, ssn_dtb.ssn_cki FROM lgn_log INNER JOIN ssn_dtb ON lgn_log.llg_sid=ssn_dtb.ssn_mid WHERE lgn_log.llg_uid=:llg_uid ORDER BY lgn_log.llg_dto DESC LIMIT 10";
		$resl = $dbcn->prepare($sqll);
		$resl->execute([
						'llg_uid'=>$_GET['val1']
					]);

		// fetch the datas from the database into the row variable
		while($rowl = $resl->fetch()) {

			// login log count variable increment
			$llct++;

			// if count is 1, then last login attempt
			if($llct == 1) {

				// last login attempt date variable into variable
				$llad = $this->tmagc($rowl['llg_dto']);

			} // last login attempt count check close

			// unset browser array
			unset($bdar);
			// brdts - browser array return from session table
			$bdar = $this->brdts($rowl['ssn_cki']);

			// add into login attempts list variable
			$lalt .= sprintf('
								<tr>
									<td class="text-center">%s</td>
									<td>%s</td>
									<td>%s</td>
									<td>%s</td>
									<td>%s</td>
									<td>%s</td>
								</tr>'
								,$llct
								,date("d-M-Y, h:i A, D", $rowl['llg_dto'])
								,$rowl['ssn_ipa']
								,isset($bdar['bwnm'])
									?
								$bdar['bwnm']
									:
								'-'
								,isset($bdar['dvnm'])
									?
								$bdar['dvnm']
									:
								'-'
								,isset($bdar['osnm'])
									?
								$bdar['osnm']
									:
								'-'
							);

		} // main list while loop iteration close

	} catch(Exception $e) {

		// error log into file
		$this->errli(NULL, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

	} // admin login attempt select close

	// login log content length check
	$lalt = strlen($lalt) > 50
				?
			$lalt
				:
			'';

// login log list table making start
$cont = <<<AAA
	<table class="table table-bordered w-100 dttsm">
		<thead>
			<tr>
				<th>SN</th>
				<th>Date</th>
				<th>IP Address</th>
				<th>Browser</th>
				<th>Device</th>
				<th>OS</th>
			</tr>
		</thead>
		<tbody>
			$lalt
		</tbody>
	</table>

AAA; // login log list table making close

	// initialize return array
	$rtar = array('lldt' => $llad, 'llct' => $cont);
	// return login log content array
	return $rtar;

}
// pwazr - preview admin users allocated zion retreats content
function pwazr() {
GLOBAL $wpfx, $dbcn;

	// sub function to create retreat list block start
	function create_retreat_block($rowz, $rttp) {
	GLOBAL $wpfx;

		// add allocated zion retreat into list
		$zrlt = sprintf('
							<div class="col-lg-4 col-md-6 mb-3" %s>
								<div class="card alert-light">
									<div class="card-body designer-card pb-3">
										<div>
											<div class="d-flex align-items-center gap-2">
												<div class="flex-grow-1">
													<a href="%spreview-zion-retreat/%s/%s" target="_blank">
														<h5>%s %s</h5>
													</a>
													<p>%s %s %s - %s %s %s</p>
												</div>
											</div>
											<div class="text-center">
												<span class="badge f-14 badge-light-%s">%s</span>
											</div>
										</div>
									</div>
								</div>
							</div>'
							,$rttp == 111
								?
							''
								:
							'style="opacity: 0.7;"'
							,$wpfx
							,$rowz['zrt_mid']
							,md5("^#" . $rowz['zrt_mid'] . "#^")
							,$rowz['rtp_nme']
							,$rowz['zrt_tns'] == 333
								?
							'<span class="txt-danger">(T)</span>'
								:
							''
							,date("d", $rowz['zrt_sdt'])
							,date("m", $rowz['zrt_sdt']) == date("m", $rowz['zrt_edt'])
								?
							''
								:
							date("M", $rowz['zrt_sdt'])
							,date("Y", $rowz['zrt_sdt']) == date("Y", $rowz['zrt_edt'])
								?
							''
								:
							date("Y", $rowz['zrt_sdt'])
							,date("d", $rowz['zrt_edt'])
							,date("M", $rowz['zrt_edt'])
							,date("Y", $rowz['zrt_edt'])
							,$rowz['zam_rtp'] == 111
								?
							'warning'
								:
							(
								$rowz['zam_rtp'] == 222
									?
								'secondary'
									:
								'primary'
							)
							,$rowz['zam_rtp'] == 111
								?
							'Main Member'
								:
							(
								$rowz['zam_rtp'] == 222
									?
								'Badge Distributor'
									:
								'Fee Collector'
							)
						);

		// return allocated zion retreat List
		return $zrlt;

	} // sub function to create retreat list block close

	// initialize return array
	$rtar = array('aczr' => '', 'hszr' => '', 'azct' => '');

	// allocated zion retreat history count variable initialize
	$azct = 0;
	// allocated zion retreat upcoming list variable initialize
	$azup = '';
	// allocated zion retreat history list variable initialize
	$azhs = '';

	// select allocated zion retreats data from database
	try {

		// allocated zion retreats selection query
		$sqlz = "SELECT rtp_tbl.rtp_nme, zrt_tbl.zrt_mid, zrt_tbl.zrt_sdt, zrt_tbl.zrt_edt, zrt_tbl.zrt_tns, zam_tbl.zam_rtp FROM zrt_tbl INNER JOIN rtp_tbl ON zrt_tbl.zrt_pid=rtp_tbl.rtp_mid INNER JOIN zam_tbl ON zrt_tbl.zrt_mid=zam_tbl.zam_zri WHERE zrt_tbl.zrt_ost=:zrt_ost AND zam_tbl.zam_adi=:zam_adi AND zam_tbl.zam_sts=:zam_sts";
		$resz = $dbcn->prepare($sqlz);
		$resz->execute([
						'zrt_ost'=>333
						,'zam_adi'=>$_GET['val1']
						,'zam_sts'=>333
					]);

		// fetch the datas from the database into the row variable
		while($rowz = $resz->fetch()) {

			// if retreat is over
			if($rowz['zrt_edt'] >= date("U")) {

				// allocated zion retreat upcoming list variable initialize
				$azup .= create_retreat_block($rowz, 111);

			// if retreat is not over
			} else {

				// increment allocated zion retreat history count variable
				$azct++;

				// if allocated zion retreat history count is less than 12
				if($azct <= 12) {

					// allocated zion retreat history list variable initialize
					$azhs .= create_retreat_block($rowz, 222);

				} // allocated zion retreat count check close

			} // retreat over check close

		} // allocated zion retreats list while loop iteration close

	} catch(Exception $e) {

		// error log into file
		$this->errli(NULL, @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

	} // allocated zion retreats select close

	// re-initialize return array
	$rtar = array('aczr' => '<div class="row dashboard-2">' . $azup . '</div>', 'hszr' => '<div class="row dashboard-2">' . $azhs . '</div>', 'azct' => $azct);

	// return zion retreats array
	return $rtar;

}


// ------- admin password reset functions -------
// cpurs - change password admin user form submit
function cpurs() {
GLOBAL $dbcn, $wpfx;

	// if form is submitted and conditions satisfied
	if(isset($_POST['pssa'], $_POST['pssb'], $_POST['pssc']) && $_POST['pssc'] == md5("|=".($_POST['pssb']-333)."=|")) {

		// page visit into log
		$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Admin change password form submitted', 'admin', 'admin-pg');

		// if form is accidently submitted
		if(isset($_POST['pssa'],$_SESSION['fmck']) && $_SESSION['fmck'] == $_POST['pssa']) {

		// if form is freshly submitted
		} else {

			// update admin password change data in database
			try {

				// admin password change update query
				$sqlg = "UPDATE adm_usr SET adm_psw=:adm_psw, adm_mdt=:adm_mdt, adm_mdu=:adm_mdu, adm_mds=:adm_mds WHERE adm_mid=:adm_mid";
				$resg = $dbcn->prepare($sqlg);
				$resg->execute([
								'adm_psw'=>md5("*^" . $_POST['nwpw'] . "^*")
								,'adm_mdt'=>date('U')
								,'adm_mdu'=>$_SESSION['urid']
								,'adm_mds'=>$_SESSION['snid']
								,'adm_mid'=>$_GET['val1']
							]);

				// alert message into variable
				$alrt = sprintf("
									<script>
										Swal.fire({
											icon: 'success',
											title: 'Password Changed',
											html: 'Admin user password successfully changed',
											confirmButtonColor: '#45afd2',
											confirmButtonText: 'Ok',
											allowOutsideClick: false,
											allowEscapeKey: false
										}).then((result) => {
											window.location.href = window.location.href;
										});
									</script>"
								);

				// admin users array
				$adar = $this->aduar('admin');

				// actar - action types array
				$acar = $this->actar();
				// action text into variable
				$actx = str_replace('***', $_POST['usnm'], $acar[1003]);

				// action log save function call
				$this->actli($_GET['val1'], 1003, $_SESSION['urid'], $actx, 'admin', 'admin-pg');

				// notification title into variable
				$nttl = 'Password changed by admin';
				// notification URL into variable
				$ntur = 'logout';
				// notification content making
				$nfct = $this->nftcm(1001, $_GET['val1'], array());
				// admin user name into variable
				$sdnm = isset($adar[$_SESSION['urid']])
							?
						$adar[$_SESSION['urid']]
							:
						'N/A';

				// add notification to datatable
				$this->ntfis($nttl, $ntur, 1001, $_GET['val1'], $nfct, 111, $_SESSION['urid'], $sdnm, $_GET['val1'], 333, 999, 333, 'admin');

			} catch(Exception $e) {

				// error log into file
				$this->errli($_GET['val1'], @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

			} // update admin password change data close

			// set the variable for the accident form submit
			$_SESSION['fmck'] = $_POST['pssa'];

			// return alert message
			return $alrt;

		} // form accidently submitted check close

	} // form submitted check close

}
// cpurf - change password admin user form html
function cpurf() {
GLOBAL $dbcn, $wpfx;

	// check get value and hash are matching
	if(isset($_GET['val1'], $_GET['val2']) && $_GET['val2'] == md5("^#" . $_GET['val1'] . "#^")) {

		// page visit into log
		$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Change admin password page requested', 'admin', 'admin-pg');

		// select admin data as per given id from database
		try {

			// admin data selection query
			$sqlp = sprintf("
								SELECT adm_usr.adm_mid, adm_usr.adm_usn, adm_usr.adm_mbi, adm_usr.adm_ltp, adm_usr.adm_prm, adm_usr.adm_sts, mbr_zid.mzi_zid, mbr_bsc.mbr_knn FROM adm_usr INNER JOIN mbr_bsc ON adm_usr.adm_mbi=mbr_bsc.mbr_mid INNER JOIN mbr_zid ON mbr_bsc.mbr_mid=mbr_zid.mzi_mbi WHERE adm_usr.adm_mid=:adm_mid"
							);
			$resp = $dbcn->prepare($sqlp);
			$resp->execute([
							'adm_mid'=>$_GET['val1']
						]);

			// fetch the datas from the database into the row variable
			$rowp = $resp->fetchAll();

		} catch(Exception $e) {

			// error log into file
			$this->errli($_GET['val1'], @$_SESSION['urid'], $e->getMessage(), $e->getLine(), $e->getFile(), 'admin', 'admin-pg');

		} // select admin data selection as per the given id close

		// if only 1 row returned the id is valid
		if(isset($rowp) && is_array($rowp) && count($rowp) == 1) {

			// page visit into log
			$this->sbmli($_GET['val1'], @$_SESSION['urid'], 'Change admin password page delivered', 'admin', 'admin-pg');

			// input hiddens for form
			$inhd = $this->inhdn();

// page content start tag start
$cont = <<<AAA
			<div class="page-body">

AAA; // page content start tag close

	// member id into variable
	$mbid = $rowp[0]['adm_mbi'];
	// member hash into variable
	$mbhs = md5("^#" . $mbid . "#^");

	// admin name into variable
	$adnm = $rowp[0]['mbr_knn'];
	// admin username into variable
	$adum = $rowp[0]['adm_usn'];

	// admin status variable
	$adst = $rowp[0]['adm_sts'] == 333
				?
			'<span class="badge badge-success">Active</span>'
				:
			'<span class="badge badge-warning">Blocked</span>';
	// admin zion id into variable
	$adzi = $rowp[0]['mzi_zid'];
	// admin type variable
	$adtp = $rowp[0]['adm_ltp'] == 333
				?
			'Admin'
				:
			'Moderator';

// admin basic info start
$cont .= <<<AAA
             <div class="card">
				 <div class="card-body">
					 <div class="social-details mt-1">
						<h4 class="text-center pb-2 common-border-b" data-aos="zoom-in">
							$adum
							<a href="{$wpfx}preview-member/$mbid/$mbhs" target="_blank" class="txt-dark f-18">
								(<u>$adnm</u>)
							</a>
						</h4>
						<ul class="social-follow text-center">
							<li data-aos="slide-right">
								<h5 class="mb-0">$adst</h5>
								<span class="f-light f-12">Admin Status</span>
							</li>
							<li data-aos="slide-up">
								<h4 class="mb-0">$adzi</h4>
								<span class="f-light f-12">Zion ID</span>
							</li>
							<li data-aos="slide-left">
								<h5 class="mb-0">$adtp</h5>
								<span class="f-light f-12">Admin Type</span>
							</li>
						</ul>
					</div>
				</div>
			</div>

AAA; // admin basic info close

// container start tag start
$cont .= <<<AAA
	<div class="container-fluid">
		<div class="row">

AAA; // container start tag close

// card start tag start
$cont .= <<<AAA
			<div class="col-md-8 offset-md-2 col-lg-6 offset-lg-3">
				<div class="card" data-aos="fade-down">

AAA; // card start tag close

// change password form start
$cont .= <<<AAA
				<form method="post" id="cpfm" class="p-2 text-center needs-validation custom-input" novalidate>

					<div class="mb-3 text-center">
						<div class="d-inline-block" style="max-width: 360px; min-width: 320px;">
							<label for="nwpw" class="mb-1">New Password <span class="text-danger">*</span></label>
							<input type="text" class="form-control" id="nwpw" name="nwpw" aria-describedby="nwpwhp" placeholder="Enter new password" autocomplete="off" minlength="4" required>
							<small id="nwpwhp" class="form-text text-muted">Enter new password for admin</small>
							<div class="invalid-tooltip">Enter minimum 4 chars password</div>	
						</div>
					</div>

					<input type="hidden" id="usnm" name="usnm" value="$adum">
					<input type="hidden" id="pssa" name="pssa" value="{$inhd[0]}">
					<input type="hidden" id="pssb" name="pssb" value="{$inhd[1]}">
					<input type="hidden" id="pssc" name="pssc" value="{$inhd[2]}">

					<div class="mt-1"> 
						<button class="btn btn-danger btn-lg f-w-600 opbt" type="submit">Change Password</button>
					</div>
				</form>

AAA; // change password form close

// card close tag start
$cont .= <<<AAA
				</div>
			</div>

AAA; // card close tag close

// container close tag start
$cont .= <<<AAA
		</div>
	</div>

AAA; // container close tag close

// page content close tag start
$cont .= <<<AAA
			</div>

AAA; // page content close tag close
echo $cont;

		} // row count check close

	} // get value check close

}
// cpurc - change password admin user additional css content
function cpurc() {

	// aoscs - aos animation css initialize call
	$this->aoscs();

}
// cpurj - change password admin user additional js content
function cpurj() {

	// aosjs - aos animation js initialize call
	$this->aosjs();
	// fmvld - form validation js initialize call
	$this->fmvld();

}


// ------- admin supporting functions -------
// adupa - admin users permissions array
function adupa() {

	// member permissions, title
	$uprm['mmbr']['titl'] = 'Members';
	// member permissions, add
	$uprm['mmbr'][111] = 'noad';
	// member permissions, list
	$uprm['mmbr'][222] = 'ltmb';
	// member permissions, edit
	$uprm['mmbr'][333] = 'noed';

	// retreat types permissions, title
	$uprm['rtpt']['titl'] = 'Retreats Types';
	// retreat types permissions, add
	$uprm['rtpt'][111] = 'noad';
	// retreat types permissions, list
	$uprm['rtpt'][222] = 'ltrp';
	// retreat types permissions, edit
	$uprm['rtpt'][333] = 'noed';

	// zion retreat permissions, title
	$uprm['znrt']['titl'] = 'Zion Retreats';
	// zion retreat permissions, add
	$uprm['znrt'][111] = 'noad';
	// zion retreat permissions, list
	$uprm['znrt'][222] = 'ltzr';
	// zion retreat permissions, edit
	$uprm['znrt'][333] = 'edzr';

	// booking permissions, title
	$uprm['bkng']['titl'] = 'Booking';
	// booking permissions, add
	$uprm['bkng'][111] = 'noad';
	// booking permissions, list
	$uprm['bkng'][222] = 'ltbk';
	// booking permissions, edit
	$uprm['bkng'][333] = 'noed';

	// registered list permissions, title
	$uprm['rgtd']['titl'] = 'Registered List';
	// registered list permissions, add
	$uprm['rgtd'][111] = 'noad';
	// registered list permissions, list
	$uprm['rgtd'][222] = 'ltrd';
	// registered list permissions, edit
	$uprm['rgtd'][333] = 'edrd';

	// registration permissions, title
	$uprm['rgtn']['titl'] = 'New Registration';
	// registration permissions, add
	$uprm['rgtn'][111] = 'adrg';
	// registration permissions, list
	$uprm['rgtn'][222] = 'ltrg';
	// registration permissions, edit
	$uprm['rgtn'][333] = 'edrg';

	// registration fees permissions, title
	$uprm['rgcs']['titl'] = 'Registration Fees';
	// registration fees permissions, add
	$uprm['rgcs'][111] = 'noad';
	// registration fees permissions, list
	$uprm['rgcs'][222] = 'ltrc';
	// registration fees permissions, edit
	$uprm['rgcs'][333] = 'noed';

	// booking statistics permissions, title
	$uprm['bkst']['titl'] = 'Booking Statistics';
	// booking statistics permissions, add
	$uprm['bkst'][111] = 'noad';
	// booking statistics permissions, list
	$uprm['bkst'][222] = 'ltbs';
	// booking statistics permissions, edit
	$uprm['bkst'][333] = 'noed';

	// registration statistics permissions, title
	$uprm['rgst']['titl'] = 'Registration Statistics';
	// registration statistics permissions, add
	$uprm['rgst'][111] = 'noad';
	// registration statistics permissions, list
	$uprm['rgst'][222] = 'ltrs';
	// registration statistics permissions, edit
	$uprm['rgst'][333] = 'noed';

	// regions permissions, title
	$uprm['rgon']['titl'] = 'Regions';
	// regions permissions, add
	$uprm['rgon'][111] = 'noad';
	// regions permissions, list
	$uprm['rgon'][222] = 'ltrn';
	// regions permissions, edit
	$uprm['rgon'][333] = 'noed';

	// zones permissions, title
	$uprm['zone']['titl'] = 'Zones';
	// zones permissions, add
	$uprm['zone'][111] = 'noad';
	// zones permissions, list
	$uprm['zone'][222] = 'ltzn';
	// zones permissions, edit
	$uprm['zone'][333] = 'noed';

	// evg areas permissions, title
	$uprm['evga']['titl'] = 'Evg Area';
	// evg areas permissions, add
	$uprm['evga'][111] = 'noad';
	// evg areas permissions, list
	$uprm['evga'][222] = 'ltea';
	// evg areas permissions, edit
	$uprm['evga'][333] = 'noed';

	// fellowships permissions, title
	$uprm['fshp']['titl'] = 'Fellowships';
	// fellowships permissions, add
	$uprm['fshp'][111] = 'noad';
	// fellowships permissions, list
	$uprm['fshp'][222] = 'ltfp';
	// fellowships permissions, edit
	$uprm['fshp'][333] = 'noed';

	// languages permissions, title
	$uprm['lang']['titl'] = 'Languages';
	// languages permissions, add
	$uprm['lang'][111] = 'noad';
	// languages permissions, list
	$uprm['lang'][222] = 'ltln';
	// languages permissions, edit
	$uprm['lang'][333] = 'noed';

	// return user permission array
	return $uprm;

}
// adcbm - admin users permissions checkbox making
function adcbm($pmar) {

	// initialize checkbox variable
	$pcbl = '
			<div class="table-responsive border border-1 border-light bg-light mt-3 rounded w-100">
				<div class="border-bottom"><h5 class="mt-2 ms-4 pb-1">Moderator Permissions</h5></div>
				<table class="table table-hover w-100">
					<thead>
						<tr class="alert-light-dark">
							<th scope="col" class="text-end text-muted">Function</th>
							<th scope="col" class="text-center text-muted">
								Add
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="saad" name="saad" type="checkbox" class="saad" value="333">
									<label class="form-check-label f-14" for="saad"</label>
								</div>
							</th>
							<th scope="col" class="text-center text-muted">
								List
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="salt" name="salt" type="checkbox" class="salt" value="333">
									<label class="form-check-label f-14" for="salt"</label>
								</div>
							</th>
							<th scope="col" class="text-center text-muted">
								Edit
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="saed" name="saed" type="checkbox" class="saed" value="333">
									<label class="form-check-label f-14" for="saed"</label>
								</div>
							</th>
						</tr>
					</thead>
					<tbody>';

	// adupa - admin users permissions array
	$upar = $this->adupa();

	// iterate permission array
	foreach($upar as $upky => $upvl) {

		// initialize checkbox variable
		$pcbl .= sprintf('<tr>');

		// if title is available
		if(isset($upvl['titl'])) {

			// initialize checkbox variable
			$pcbl .= sprintf('
								<td class="text-end f-w-500 txt-dark p-2">%s</td>'
								,$upvl['titl']
							);

			// add checkbox creation
			$adcb = sprintf('
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="%s%s" name="pmar[%s]" type="checkbox" class="saac" value="333" %s>
									<label class="form-check-label f-14" for="%s%s"</label>
								</div>'
								,$upky
								,$upvl[111]
								,$upvl[111]
								,(isset($_POST['pmar']) && isset($_POST['pmar'][$upvl[111]]))
									?
								'checked'
									:
								(
									isset($pmar[$upvl[111]])
										?
									'checked'
										:
									''
								)
								,$upky
								,$upvl[111]
							);

			// create add permission checkbox
			$pcbl .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[111] == 'noad'
									?
								'-'
									:
								$adcb
							);

			// list checkbox creation
			$ltcb = sprintf('
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="%s%s" name="pmar[%s]" type="checkbox" class="salc" value="333" %s>
									<label class="form-check-label f-14" for="%s%s"</label>
								</div>'
								,$upky
								,$upvl[222]
								,$upvl[222]
								,(isset($_POST['pmar']) && isset($_POST['pmar'][$upvl[222]]))
									?
								'checked'
									:
								(
									isset($pmar[$upvl[222]])
										?
									'checked'
										:
									''
								)
								,$upky
								,$upvl[222]
							);

			// create list permission checkbox
			$pcbl .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[222] == 'nolt'
									?
								'-'
									:
								$ltcb
							);

			// edit checkbox creation
			$edcb = sprintf('
								<div class="checkbox checkbox-primary mb-0 ms-3 mt-0">
									<input id="%s%s" name="pmar[%s]" type="checkbox" class="saec" value="333" %s>
									<label class="form-check-label f-14" for="%s%s"</label>
								</div>'
								,$upky
								,$upvl[333]
								,$upvl[333]
								,(isset($_POST['pmar']) && isset($_POST['pmar'][$upvl[333]]))
									?
								'checked'
									:
								(
									isset($pmar[$upvl[333]])
										?
									'checked'
										:
									''
								)
								,$upky
								,$upvl[333]
							);

			// create edit permission checkbox
			$pcbl .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[333] == 'noed'
									?
								'-'
									:
								$edcb
							);

		} // title available check close

		// initialize checkbox variable
		$pcbl .= sprintf('</tr>');

	} // permission array iteration close

	// add into checkbox variable
	$pcbl .= '
					</table>
				</tbody>
			</div>';

	// return checkbox content
	return $pcbl;

}
// adplt - admin users permissions list making
function adplt($pmct, $adtp) {

	// initialize permissions list variable
	$plbk = '
			<div class="table-responsive w-100">
				<table class="table table-hover dttsm w-100">
					<thead>
						<tr class="alert-light-dark">
							<th scope="col" class="text-end text-muted">Function</th>
							<th scope="col" class="text-center text-muted">Add</th>
							<th scope="col" class="text-center text-muted">List</th>
							<th scope="col" class="text-center text-muted">Edit</th>
						</tr>
					</thead>
					<tbody>';

	// adupa - admin users permissions array
	$upar = $this->adupa();

	// permission array from given input
	$pmar = (isset($pmct) && strlen($pmct) > 10)
				?
			unserialize($pmct)
				:
			array();

	// iterate permission array
	foreach($upar as $upky => $upvl) {

		// initialize permission list variable
		$plbk .= sprintf('<tr>');

		// if title is available
		if(isset($upvl['titl'])) {

			// initialize permission list variable
			$plbk .= sprintf('
								<td class="text-end f-w-500 txt-dark p-2">%s</td>'
								,$upvl['titl']
							);

			// add permission list creation
			$adcb = sprintf('
								%s'
								,(isset($pmar) && isset($pmar[$upvl[111]]))
									?
								'<i class="fa fa-check txt-success f-16"></i>'
									:
								'<i class="fa fa-close txt-danger f-16"></i>'
							);

			// create add permission list
			$plbk .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[111] == 'noad'
									?
								'-'
									:
								$adcb
							);

			// permission list creation
			$ltcb = sprintf('
								%s'
								,(isset($pmar) && isset($pmar[$upvl[222]]))
									?
								'<i class="fa fa-check txt-success f-16"></i>'
									:
								'<i class="fa fa-close txt-danger f-16"></i>'
							);

			// create permission list
			$plbk .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[222] == 'nolt'
									?
								'-'
									:
								$ltcb
							);

			// edit permission list creation
			$edcb = sprintf('
								%s'
								,(isset($pmar) && isset($pmar[$upvl[333]]))
									?
								'<i class="fa fa-check txt-success f-16"></i>'
									:
								'<i class="fa fa-close txt-danger f-16"></i>'
							);

			// create edit permission list
			$plbk .= sprintf('
								<td class="text-center p-2">
									%s
								</td>'
								,$upvl[333] == 'noed'
									?
								'-'
									:
								$edcb
							);

		} // title available check close

		// initialize permission list variable
		$plbk .= sprintf('</tr>');

	} // permission array iteration close

	// add into permission list variable
	$plbk .= '
					</table>
				</tbody>
			</div>';

	// permission block content return management
	$prrc = $adtp == 111
				?
			'<h5 class="pt-4 pb-4 ps-5 txt-danger">Admin user have all the permissions by default</h5>'
				:
			$plbk;

	// return permission list content
	return $prrc;

}

}//class closed
?>